/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.NodeDetail;
import org.custommonkey.xmlunit.XMLUnit;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.concurrent.SingleThreaded;
import org.jclouds.concurrent.config.ConfiguresExecutorService;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.DateServiceDateCodecFactory;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.HttpApiMetadata;
import org.jclouds.rest.config.CredentialStoreModule;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.w3c.dom.Node;

@Beta
public abstract class BaseRestApiExpectTest<S> {
    protected String provider = "mock";
    protected ContentMetadataCodec contentMetadataCodec = new ContentMetadataCodec.DefaultContentMetadataCodec((DateCodecFactory)new DateServiceDateCodecFactory((DateService)new SimpleDateFormatDateService()));
    protected String identity = "identity";
    protected String credential = "credential";
    protected Class<?> api;

    protected Module createModule() {
        return new Module(){

            public void configure(Binder binder) {
            }
        };
    }

    public Payload payloadFromResource(String resource) {
        try {
            return BaseRestApiExpectTest.payloadFromString(Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream(resource)));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Payload payloadFromResourceWithContentType(String resource, String contentType) {
        try {
            return BaseRestApiExpectTest.payloadFromStringWithContentType(Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream(resource)), contentType);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Payload payloadFromString(String payload) {
        return Payloads.newStringPayload((String)payload);
    }

    public static Payload payloadFromStringWithContentType(String payload, String contentType) {
        StringPayload p = Payloads.newStringPayload((String)payload);
        p.getContentMetadata().setContentType(contentType);
        return p;
    }

    public S requestSendsResponse(HttpRequest request, HttpResponse response) {
        return this.requestSendsResponse(request, response, this.createModule());
    }

    public S requestSendsResponse(HttpRequest request, HttpResponse response, Module module) {
        return this.requestsSendResponses((Map<HttpRequest, HttpResponse>)ImmutableMap.of((Object)request, (Object)response), module);
    }

    public S requestsSendResponses(HttpRequest requestA, HttpResponse responseA, HttpRequest requestB, HttpResponse responseB) {
        return this.requestsSendResponses(requestA, responseA, requestB, responseB, this.createModule());
    }

    public S requestsSendResponses(HttpRequest requestA, HttpResponse responseA, HttpRequest requestB, HttpResponse responseB, Module module) {
        return this.requestsSendResponses((Map<HttpRequest, HttpResponse>)ImmutableMap.of((Object)requestA, (Object)responseA, (Object)requestB, (Object)responseB), module);
    }

    public S requestsSendResponses(HttpRequest requestA, HttpResponse responseA, HttpRequest requestB, HttpResponse responseB, HttpRequest requestC, HttpResponse responseC) {
        return this.requestsSendResponses(requestA, responseA, requestB, responseB, requestC, responseC, this.createModule());
    }

    public S requestsSendResponses(HttpRequest requestA, HttpResponse responseA, HttpRequest requestB, HttpResponse responseB, HttpRequest requestC, HttpResponse responseC, Module module) {
        return this.requestsSendResponses((Map<HttpRequest, HttpResponse>)ImmutableMap.of((Object)requestA, (Object)responseA, (Object)requestB, (Object)responseB, (Object)requestC, (Object)responseC), module);
    }

    public S orderedRequestsSendResponses(HttpRequest requestA, HttpResponse responseA, HttpRequest requestB, HttpResponse responseB) {
        return this.orderedRequestsSendResponses((List<HttpRequest>)ImmutableList.of((Object)requestA, (Object)requestB), (List<HttpResponse>)ImmutableList.of((Object)responseA, (Object)responseB));
    }

    public S orderedRequestsSendResponses(HttpRequest requestA, HttpResponse responseA, HttpRequest requestB, HttpResponse responseB, HttpRequest requestC, HttpResponse responseC) {
        return this.orderedRequestsSendResponses((List<HttpRequest>)ImmutableList.of((Object)requestA, (Object)requestB, (Object)requestC), (List<HttpResponse>)ImmutableList.of((Object)responseA, (Object)responseB, (Object)responseC));
    }

    public S orderedRequestsSendResponses(HttpRequest requestA, HttpResponse responseA, HttpRequest requestB, HttpResponse responseB, HttpRequest requestC, HttpResponse responseC, HttpRequest requestD, HttpResponse responseD) {
        return this.orderedRequestsSendResponses((List<HttpRequest>)ImmutableList.of((Object)requestA, (Object)requestB, (Object)requestC, (Object)requestD), (List<HttpResponse>)ImmutableList.of((Object)responseA, (Object)responseB, (Object)responseC, (Object)responseD));
    }

    public S orderedRequestsSendResponses(final List<HttpRequest> requests, final List<HttpResponse> responses) {
        final AtomicInteger counter = new AtomicInteger(0);
        return this.createClient(new Function<HttpRequest, HttpResponse>(){

            public HttpResponse apply(HttpRequest input) {
                int index = counter.getAndIncrement();
                if (index >= requests.size()) {
                    return ((HttpResponse.Builder)HttpResponse.builder().statusCode(500).message(String.format("request %s is out of range (%s)", index, requests.size())).payload((Payload)Payloads.newStringPayload((String)BaseRestApiExpectTest.this.renderRequest(input)))).build();
                }
                if (!BaseRestApiExpectTest.this.httpRequestsAreEqual(input, (HttpRequest)requests.get(index))) {
                    Assert.assertEquals((String)BaseRestApiExpectTest.this.renderRequest(input), (String)BaseRestApiExpectTest.this.renderRequest((HttpRequest)requests.get(index)));
                }
                return (HttpResponse)responses.get(index);
            }
        });
    }

    public S requestsSendResponses(Map<HttpRequest, HttpResponse> requestToResponse) {
        return this.requestsSendResponses(requestToResponse, this.createModule());
    }

    protected HttpRequestComparisonType compareHttpRequestAsType(HttpRequest input) {
        return HttpRequestComparisonType.DEFAULT;
    }

    public boolean httpRequestsAreEqual(HttpRequest a, HttpRequest b) {
        try {
            if (a == null || b == null || !Objects.equal((Object)a.getRequestLine(), (Object)b.getRequestLine()) || !Objects.equal((Object)a.getHeaders(), (Object)b.getHeaders())) {
                return false;
            }
            if (a.getPayload() == null || b.getPayload() == null) {
                return Objects.equal((Object)a, (Object)b);
            }
            switch (this.compareHttpRequestAsType(a)) {
                case XML: {
                    Diff diff = XMLUnit.compareXML((String)Strings2.toStringAndClose((InputStream)a.getPayload().openStream()), (String)Strings2.toStringAndClose((InputStream)b.getPayload().openStream()));
                    diff.overrideDifferenceListener(new DifferenceListener(){

                        public int differenceFound(Difference diff) {
                            if (diff.getId() == 23 || diff.getId() == 15) {
                                return 1;
                            }
                            if (diff.getId() == 14) {
                                for (NodeDetail detail : ImmutableSet.of((Object)diff.getControlNodeDetail(), (Object)diff.getTestNodeDetail())) {
                                    if (detail.getNode().getParentNode().getChildNodes().getLength() >= 2 && detail.getValue().trim().isEmpty()) continue;
                                    return 0;
                                }
                                return 1;
                            }
                            return 0;
                        }

                        public void skippedComparison(Node node, Node node1) {
                        }
                    });
                    return diff.identical();
                }
                case JSON: {
                    JsonParser parser = new JsonParser();
                    JsonElement payloadA = parser.parse(Strings2.toStringAndClose((InputStream)a.getPayload().openStream()));
                    JsonElement payloadB = parser.parse(Strings2.toStringAndClose((InputStream)b.getPayload().openStream()));
                    return Objects.equal((Object)payloadA, (Object)payloadB);
                }
            }
            return Objects.equal((Object)a, (Object)b);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public S requestsSendResponses(Map<HttpRequest, HttpResponse> requestToResponse, Module module) {
        return this.requestsSendResponses(requestToResponse, module, this.setupProperties());
    }

    public S requestsSendResponses(final Map<HttpRequest, HttpResponse> requestToResponse, Module module, Properties props) {
        return this.createClient(new Function<HttpRequest, HttpResponse>(){

            public HttpResponse apply(HttpRequest input) {
                HttpRequest matchedRequest = null;
                HttpResponse response = null;
                for (Map.Entry entry : requestToResponse.entrySet()) {
                    HttpRequest request = (HttpRequest)entry.getKey();
                    if (!BaseRestApiExpectTest.this.httpRequestsAreEqual(input, request)) continue;
                    matchedRequest = request;
                    response = (HttpResponse)entry.getValue();
                }
                if (response == null) {
                    StringBuilder payload = new StringBuilder("\n");
                    payload.append("\n----------------------------------------\n");
                    payload.append("The following request is not configured:\n");
                    payload.append("----------------------------------------\n");
                    payload.append(BaseRestApiExpectTest.this.renderRequest(input));
                    payload.append("\n----------------------------------------\n");
                    payload.append("Configured requests:\n");
                    for (HttpRequest request : requestToResponse.keySet()) {
                        payload.append("\n----------------------------------------\n");
                        payload.append(BaseRestApiExpectTest.this.renderRequest(request));
                    }
                    response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(500).message("no response configured for request").payload((Payload)Payloads.newStringPayload((String)payload.toString()))).build();
                } else if (BaseRestApiExpectTest.this.compareHttpRequestAsType(input) == HttpRequestComparisonType.DEFAULT) {
                    Assert.assertEquals((String)BaseRestApiExpectTest.this.renderRequest(input), (String)BaseRestApiExpectTest.this.renderRequest(matchedRequest));
                }
                return response;
            }
        }, module, props);
    }

    public String renderRequest(HttpRequest request) {
        StringBuilder builder = new StringBuilder().append(request.getRequestLine()).append('\n');
        for (Map.Entry header : request.getHeaders().entries()) {
            builder.append((String)header.getKey()).append(": ").append((String)header.getValue()).append('\n');
        }
        if (request.getPayload() != null) {
            for (Map.Entry header : this.contentMetadataCodec.toHeaders((ContentMetadata)request.getPayload().getContentMetadata()).entries()) {
                builder.append((String)header.getKey()).append(": ").append((String)header.getValue()).append('\n');
            }
            try {
                builder.append('\n').append(Strings2.toStringAndClose((InputStream)request.getPayload().openStream()));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else {
            builder.append('\n');
        }
        return builder.toString();
    }

    public S createClient(Function<HttpRequest, HttpResponse> fn) {
        return this.createClient(fn, this.createModule(), this.setupProperties());
    }

    public S createClient(Function<HttpRequest, HttpResponse> fn, Module module) {
        return this.createClient(fn, module, this.setupProperties());
    }

    public S createClient(Function<HttpRequest, HttpResponse> fn, Properties props) {
        return this.createClient(fn, this.createModule(), props);
    }

    public S createClient(Function<HttpRequest, HttpResponse> fn, Module module, Properties props) {
        return (S)this.createInjector(fn, module, props).getInstance(this.api);
    }

    protected ProviderMetadata createProviderMetadata() {
        return null;
    }

    protected ApiMetadata createApiMetadata() {
        return null;
    }

    protected Injector createInjector(Function<HttpRequest, HttpResponse> fn, Module module, Properties props) {
        ApiMetadata am;
        ContextBuilder builder = null;
        if (this.provider != null) {
            try {
                builder = ContextBuilder.newBuilder((String)this.provider).credentials(this.identity, this.credential);
            }
            catch (NoSuchElementException e) {
                Logger.getAnonymousLogger().warning("provider [" + this.provider + "] is not setup as META-INF/services/org.jclouds.apis.ApiMetadata or META-INF/services/org.jclouds.providers.ProviderMetadata");
            }
        }
        if (builder == null) {
            ProviderMetadata pm = this.createProviderMetadata();
            ApiMetadata am2 = pm != null ? pm.getApiMetadata() : (ApiMetadata)Preconditions.checkNotNull((Object)this.createApiMetadata(), (Object)"either createApiMetadata or createProviderMetadata must be overridden");
            ContextBuilder contextBuilder = builder = pm != null ? ContextBuilder.newBuilder((ProviderMetadata)pm) : ContextBuilder.newBuilder((ApiMetadata)am2);
        }
        if (!((am = builder.getApiMetadata()) instanceof HttpApiMetadata)) {
            throw new UnsupportedOperationException("unsupported base type: " + am);
        }
        this.api = ((HttpApiMetadata)HttpApiMetadata.class.cast(am)).getApi();
        return builder.credentials(this.identity, this.credential).modules((Iterable)ImmutableSet.of((Object)((Object)new ExpectModule(fn)), (Object)new NullLoggingModule(), (Object)new CredentialStoreModule(new ConcurrentHashMap()), (Object)module)).overrides(props).buildInjector();
    }

    protected Properties setupProperties() {
        Properties props = new Properties();
        props.put("jclouds.max-retries", (Object)1);
        return props;
    }

    protected static enum HttpRequestComparisonType {
        XML,
        JSON,
        DEFAULT;

    }

    @ConfiguresHttpCommandExecutorService
    @ConfiguresExecutorService
    public static class ExpectModule
    extends AbstractModule {
        private final Function<HttpRequest, HttpResponse> fn;

        public ExpectModule(Function<HttpRequest, HttpResponse> fn) {
            this.fn = (Function)Preconditions.checkNotNull(fn, (Object)"fn");
        }

        public void configure() {
            this.bind(ListeningExecutorService.class).annotatedWith((Annotation)Names.named((String)"jclouds.user-threads")).toInstance((Object)MoreExecutors.sameThreadExecutor());
            this.bind((TypeLiteral)new TypeLiteral<Function<HttpRequest, HttpResponse>>(){}).toInstance(this.fn);
            this.bind(HttpCommandExecutorService.class).to(ExpectHttpCommandExecutorService.class);
        }

        @Provides
        @Singleton
        TimeLimiter timeLimiter(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
            return new SimpleTimeLimiter((ExecutorService)userExecutor);
        }
    }

    @SingleThreaded
    @Singleton
    public static class ExpectHttpCommandExecutorService
    extends BaseHttpCommandExecutorService<HttpRequest> {
        private final Function<HttpRequest, HttpResponse> fn;

        @Inject
        public ExpectHttpCommandExecutorService(Function<HttpRequest, HttpResponse> fn, HttpUtils utils, ContentMetadataCodec contentMetadataCodec, IOExceptionRetryHandler ioRetryHandler, DelegatingRetryHandler retryHandler, DelegatingErrorHandler errorHandler, HttpWire wire) {
            super(utils, contentMetadataCodec, retryHandler, ioRetryHandler, errorHandler, wire);
            this.fn = (Function)Preconditions.checkNotNull(fn, (Object)"fn");
        }

        public void cleanup(HttpRequest nativeResponse) {
            if (nativeResponse != null && nativeResponse.getPayload() != null) {
                nativeResponse.getPayload().release();
            }
        }

        public HttpRequest convert(HttpRequest request) throws IOException, InterruptedException {
            return request;
        }

        public HttpResponse invoke(HttpRequest nativeRequest) throws IOException, InterruptedException {
            return (HttpResponse)this.fn.apply((Object)nativeRequest);
        }
    }
}

