/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.hash.Hashing;
import com.google.common.reflect.Invokable;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;
import org.easymock.EasyMock;
import org.jclouds.concurrent.config.ConfiguresExecutorService;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.TransformerForRequest;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public abstract class BaseRestApiTest {
    protected Injector injector;
    protected ParseSax.Factory parserFactory;

    protected void assertPayloadEquals(HttpRequest request, String toMatch, String contentType, boolean contentMD5) {
        this.assertPayloadEquals(request, toMatch, contentType, contentMD5, null);
    }

    protected void assertPayloadEquals(HttpRequest request, String toMatch, String contentType, boolean contentMD5, Date expires) {
        this.assertPayloadEquals(request, toMatch, contentType, null, null, null, contentMD5, expires);
    }

    protected void assertPayloadEquals(HttpRequest request, String toMatch, String contentType, String contentDispositon, String contentEncoding, String contentLanguage, boolean contentMD5) {
        this.assertPayloadEquals(request, toMatch, contentType, contentDispositon, contentEncoding, contentLanguage, contentMD5, null);
    }

    protected void assertPayloadEquals(HttpRequest request, String toMatch, String contentType, String contentDispositon, String contentEncoding, String contentLanguage, boolean contentMD5, Date expires) {
        if (request.getPayload() == null) {
            Assert.assertNull((Object)toMatch);
        } else {
            String payload = null;
            try {
                payload = Strings2.toStringAndClose((InputStream)request.getPayload().openStream());
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
            Assert.assertEquals((String)payload, (String)toMatch);
            Long length = payload.getBytes().length;
            this.assertContentHeadersEqual(request, contentType, contentDispositon, contentEncoding, contentLanguage, length, contentMD5 ? Hashing.md5().hashBytes(payload.getBytes()).asBytes() : null, expires);
        }
    }

    protected void assertContentHeadersEqual(HttpRequest request, String contentType, String contentDispositon, String contentEncoding, String contentLanguage, Long length, byte[] contentMD5, Date expires) {
        MutableContentMetadata md = request.getPayload().getContentMetadata();
        if (request.getFirstHeaderOrNull("Transfer-Encoding") == null) {
            Assert.assertEquals((Object)md.getContentLength(), (Object)length);
        } else {
            Assert.assertEquals((String)request.getFirstHeaderOrNull("Transfer-Encoding"), (String)"chunked");
            assert (md.getContentLength() == null || md.getContentLength().equals(length));
        }
        Assert.assertEquals((String)md.getContentType(), (String)contentType);
        Assert.assertEquals((String)md.getContentDisposition(), (String)contentDispositon);
        Assert.assertEquals((String)md.getContentEncoding(), (String)contentEncoding);
        Assert.assertEquals((String)md.getContentLanguage(), (String)contentLanguage);
        Assert.assertEquals((byte[])md.getContentMD5(), (byte[])contentMD5);
        Assert.assertEquals((Object)md.getExpires(), (Object)expires);
    }

    protected void assertNonPayloadHeadersEqual(HttpRequest request, String toMatch) {
        Assert.assertEquals((String)BaseRestApiTest.sortAndConcatHeadersIntoString((Multimap<String, String>)request.getHeaders()), (String)toMatch);
    }

    public static String sortAndConcatHeadersIntoString(Multimap<String, String> headers) {
        StringBuilder buffer = new StringBuilder();
        TreeMultimap sortedMap = TreeMultimap.create();
        sortedMap.putAll(headers);
        for (Map.Entry header : sortedMap.entries()) {
            if (header.getKey() == null) continue;
            buffer.append(String.format("%s: %s\n", header.getKey(), header.getValue()));
        }
        return buffer.toString();
    }

    protected void assertRequestLineEquals(HttpRequest request, String toMatch) {
        Assert.assertEquals((String)request.getRequestLine(), (String)toMatch);
    }

    protected void assertFallbackClassEquals(Invokable<?, ?> method, @Nullable Class<?> expected) {
        Class assigned;
        Fallback fallbackAnnotation = (Fallback)method.getAnnotation(Fallback.class);
        Class clazz = assigned = fallbackAnnotation != null ? fallbackAnnotation.value() : MapHttp4xxCodesToExceptions.class;
        if (expected == null) {
            Assert.assertEquals((Object)assigned, MapHttp4xxCodesToExceptions.class);
        } else {
            Assert.assertEquals((Object)assigned, expected);
        }
    }

    protected void assertSaxResponseParserClassEquals(Invokable<?, ?> method, @Nullable Class<?> parserClass) {
        XMLResponseParser annotation = (XMLResponseParser)method.getAnnotation(XMLResponseParser.class);
        Class expected = annotation != null ? annotation.value() : null;
        Assert.assertEquals((Object)expected, parserClass);
    }

    protected void assertResponseParserClassEquals(Invokable<?, ?> method, GeneratedHttpRequest request, @Nullable Class<?> parserClass) {
        Assert.assertEquals(((TransformerForRequest)this.injector.getInstance(TransformerForRequest.class)).apply((HttpRequest)request).getClass(), parserClass);
    }

    @ConfiguresHttpCommandExecutorService
    @ConfiguresExecutorService
    public static class MockModule
    extends AbstractModule {
        private final HttpCommandExecutorService mock;

        public MockModule() {
            this((HttpCommandExecutorService)EasyMock.createMock(HttpCommandExecutorService.class));
        }

        public MockModule(HttpCommandExecutorService mock) {
            this.mock = mock;
        }

        protected void configure() {
            this.bind(ListeningExecutorService.class).annotatedWith((Annotation)Names.named((String)"jclouds.user-threads")).toInstance((Object)MoreExecutors.sameThreadExecutor());
            this.bind(HttpCommandExecutorService.class).toInstance((Object)this.mock);
        }

        @Provides
        @Singleton
        TimeLimiter timeLimiter(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
            return new SimpleTimeLimiter((ExecutorService)userExecutor);
        }
    }
}

