/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.concurrent.TransformParallelException;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="FutureIterablesTest")
public class FutureIterablesTest {
    public void testAuthorizationExceptionPropagatesAndOnlyTriesOncePerElement() {
        final AtomicInteger counter = new AtomicInteger();
        try {
            FutureIterables.transformParallel((Iterable)ImmutableSet.of((Object)"hello", (Object)"goodbye"), (Function)new Function<String, ListenableFuture<? extends String>>(){

                public ListenableFuture<String> apply(String input) {
                    counter.incrementAndGet();
                    return Futures.immediateFailedFuture((Throwable)new AuthorizationException());
                }
            }, (ListeningExecutorService)MoreExecutors.sameThreadExecutor(), null, (Logger)Logger.NULL, (String)"");
            Assert.fail((String)"Expected AuthorizationException");
        }
        catch (AuthorizationException e) {
            Assert.assertEquals((int)counter.get(), (int)2);
        }
    }

    public void testNormalExceptionPropagatesAsTransformParallelExceptionAndTries5XPerElement() {
        final AtomicInteger counter = new AtomicInteger();
        try {
            FutureIterables.transformParallel((Iterable)ImmutableSet.of((Object)"hello", (Object)"goodbye"), (Function)new Function<String, ListenableFuture<? extends String>>(){

                public ListenableFuture<String> apply(String input) {
                    counter.incrementAndGet();
                    return Futures.immediateFailedFuture((Throwable)new RuntimeException());
                }
            }, (ListeningExecutorService)MoreExecutors.sameThreadExecutor(), null, (Logger)Logger.CONSOLE, (String)"");
            Assert.fail((String)"Expected TransformParallelException");
        }
        catch (TransformParallelException e) {
            Assert.assertEquals((int)e.getFromToException().size(), (int)2);
            Assert.assertEquals((int)counter.get(), (int)10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAwaitCompletionTimeout() throws Exception {
        long timeoutMs = 1000L;
        ListeningExecutorService userExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());
        HashMap responses = Maps.newHashMap();
        try {
            responses.put(null, userExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }));
            Map errors = FutureIterables.awaitCompletion((Map)responses, (ListeningExecutorService)userExecutor, (Long)1000L, (Logger)Logger.NULL, (String)"");
            if (!errors.isEmpty()) {
                throw (Exception)errors.values().iterator().next();
            }
            Assert.fail((String)"Did not throw TimeoutException");
        }
        catch (TimeoutException te) {
        }
        finally {
            userExecutor.shutdownNow();
        }
    }
}

