/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.date.internal;

import org.jclouds.date.internal.DateUtils;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DateUtilsTest")
public class DateUtilsTest {
    @Test
    public void testTrimsToMillisWithTimezone() {
        AssertJUnit.assertEquals((String)"NO_MILLISZ", (String)DateUtils.trimToMillis((String)"NO_MILLISZ"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.1Z", (String)DateUtils.trimToMillis((String)"NO_MILLIS.1Z"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.12Z", (String)DateUtils.trimToMillis((String)"NO_MILLIS.12Z"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123Z", (String)DateUtils.trimToMillis((String)"NO_MILLIS.123Z"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123Z", (String)DateUtils.trimToMillis((String)"NO_MILLIS.1234Z"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123Z", (String)DateUtils.trimToMillis((String)"NO_MILLIS.12345Z"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123Z", (String)DateUtils.trimToMillis((String)"NO_MILLIS.123456Z"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123Z", (String)DateUtils.trimToMillis((String)"NO_MILLIS.1234567Z"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123Z", (String)DateUtils.trimToMillis((String)"NO_MILLIS.12345689Z"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123Z", (String)DateUtils.trimToMillis((String)"NO_MILLIS.12345690123345678Z"));
    }

    @Test
    public void testTrimsToMillisNoTimezone() {
        AssertJUnit.assertEquals((String)"NO_MILLIS", (String)DateUtils.trimToMillis((String)"NO_MILLIS"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.1", (String)DateUtils.trimToMillis((String)"NO_MILLIS.1"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.12", (String)DateUtils.trimToMillis((String)"NO_MILLIS.12"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123", (String)DateUtils.trimToMillis((String)"NO_MILLIS.123"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123", (String)DateUtils.trimToMillis((String)"NO_MILLIS.1234"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123", (String)DateUtils.trimToMillis((String)"NO_MILLIS.12345"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123", (String)DateUtils.trimToMillis((String)"NO_MILLIS.123456"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123", (String)DateUtils.trimToMillis((String)"NO_MILLIS.1234567"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123", (String)DateUtils.trimToMillis((String)"NO_MILLIS.12345689"));
        AssertJUnit.assertEquals((String)"NO_MILLIS.123", (String)DateUtils.trimToMillis((String)"NO_MILLIS.12345690123345678"));
    }
}

