/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.fallbacks;

import org.jclouds.fallbacks.HeaderToRetryAfterExceptionTest;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.fallbacks.PropagateIfRetryAfter;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.RetryAfterException;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class MapHttp4xxCodesToExceptionsTest {
    MapHttp4xxCodesToExceptions fn = new MapHttp4xxCodesToExceptions((PropagateIfRetryAfter)HeaderToRetryAfterExceptionTest.fn);
    HttpCommand command = HeaderToRetryAfterExceptionTest.command;

    @Test(expectedExceptions={AuthorizationException.class})
    public void test401ToAuthorizationException() throws Exception {
        this.fn.createOrPropagate((Throwable)new HttpResponseException(this.command, HttpResponse.builder().statusCode(401).build()));
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void test403ToAuthorizationException() throws Exception {
        this.fn.createOrPropagate((Throwable)new HttpResponseException(this.command, HttpResponse.builder().statusCode(403).build()));
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void test404ToResourceNotFoundException() throws Exception {
        this.fn.createOrPropagate((Throwable)new HttpResponseException(this.command, HttpResponse.builder().statusCode(404).build()));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void test409ToIllegalStateException() throws Exception {
        this.fn.createOrPropagate((Throwable)new HttpResponseException(this.command, HttpResponse.builder().statusCode(409).build()));
    }

    @Test(expectedExceptions={RetryAfterException.class}, expectedExceptionsMessageRegExp="retry now")
    public void testHttpResponseExceptionWithRetryAfterDate() throws Exception {
        this.fn.createOrPropagate((Throwable)new HttpResponseException(this.command, ((HttpResponse.Builder)HttpResponse.builder().statusCode(503).addHeader("Retry-After", new String[]{"Fri, 31 Dec 1999 23:59:59 GMT"})).build()));
    }

    @Test(expectedExceptions={RetryAfterException.class}, expectedExceptionsMessageRegExp="retry in 700 seconds")
    public void testHttpResponseExceptionWithRetryAfterOffset() throws Exception {
        this.fn.createOrPropagate((Throwable)new HttpResponseException(this.command, ((HttpResponse.Builder)HttpResponse.builder().statusCode(503).addHeader("Retry-After", new String[]{"700"})).build()));
    }

    @Test(expectedExceptions={RetryAfterException.class}, expectedExceptionsMessageRegExp="retry in 86400 seconds")
    public void testHttpResponseExceptionWithRetryAfterPastIsZero() throws Exception {
        this.fn.createOrPropagate((Throwable)new HttpResponseException(this.command, ((HttpResponse.Builder)HttpResponse.builder().statusCode(503).addHeader("Retry-After", new String[]{"Sun, 2 Jan 2000 00:00:00 GMT"})).build()));
    }
}

