/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.jclouds.http.BaseMockWebServerTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.http.options.GetOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.util.Closeables2;
import org.jclouds.util.Strings2;
import org.jclouds.utils.TestUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public abstract class BaseHttpCommandExecutorServiceIntegrationTest
extends BaseMockWebServerTest {
    private static final String XML = "<foo><bar>whoppers</bar></foo>";
    private static final String XML2 = "<foo><bar>chubbs</bar></foo>";
    private static final ByteSource oneHundredOneConstitutions = TestUtils.randomByteSource().slice(0L, 4556918L);

    @BeforeClass(groups={"integration"})
    public void setup() throws IOException {
    }

    protected IntegrationTestClient client(String url) {
        return this.api(IntegrationTestClient.class, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestFilter() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody("test"));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.downloadFilter("", "filterme");
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)request.getHeader("filterme"), (String)"filterme");
            Assert.assertEquals((String)request.getHeader("test"), (String)"test");
            Assert.assertEquals((String)result, (String)"test");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStringWithHeader() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody("test"));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.download("", "test");
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)request.getHeader("test"), (String)"test");
            Assert.assertEquals((String)result, (String)"test");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetString() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody(XML));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            Assert.assertEquals((String)client.download(""), (String)XML);
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStringIsRetriedOnFailure() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setResponseCode(500), new MockResponse().setBody(XML));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.download("");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)result, (String)XML);
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStringViaRequest() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody(XML));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            HttpResponse getStringResponse = client.invoke(HttpRequest.builder().method("GET").endpoint(server.getUrl("/objects").toString()).build());
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)getStringResponse.getPayload().openStream()).trim(), (String)XML);
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    @DataProvider(name="gets")
    public Object[][] createData() {
        return new Object[][]{{"object"}, {"/path"}, {"sp ace"}, {"unic\u20aade"}, {"qu?stion"}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="gets")
    public void testGetStringSynch(String uri) throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody(XML));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.synch(uri);
            RecordedRequest request = server.takeRequest();
            Assert.assertTrue((boolean)URLDecoder.decode(request.getPath(), "UTF-8").endsWith(uri));
            Assert.assertEquals((String)result, (String)XML);
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetException() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setResponseCode(404));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.downloadException("", (HttpRequestOptions)GetOptions.Builder.tail((long)1L));
            Assert.assertEquals((String)result, (String)"foo");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSynchException() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setResponseCode(404));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.synchException("", "");
            Assert.assertEquals((String)result, (String)"foo");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStringRedirect() throws Exception {
        MockWebServer redirectTarget = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody(XML2));
        redirectTarget.useHttps(this.sslContext.getSocketFactory(), false);
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setResponseCode(302).setHeader("Location", (Object)redirectTarget.getUrl("/").toString()));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.download("redirect");
            Assert.assertEquals((String)result, (String)XML2);
            Assert.assertEquals((int)server.getRequestCount(), (int)1);
            Assert.assertEquals((int)redirectTarget.getRequestCount(), (int)1);
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            redirectTarget.shutdown();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBigFile() throws Exception {
        String constitutionsMd5 = BaseEncoding.base64().encode(oneHundredOneConstitutions.hash(Hashing.md5()).asBytes());
        MockResponse response = new MockResponse().addHeader("Content-MD5", (Object)constitutionsMd5).addHeader("Content-type", (Object)"text/plain").setBody(oneHundredOneConstitutions.openStream(), oneHundredOneConstitutions.size());
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(response, response);
        InputStream input = server.getUrl("/101constitutions").openStream();
        try {
            this.assertValidMd5(input, constitutionsMd5);
        }
        catch (RuntimeException e) {
        }
        finally {
            Closeables2.closeQuietly((Closeable)input);
        }
    }

    private void assertValidMd5(InputStream input, String md5) throws IOException {
        Assert.assertEquals((String)BaseEncoding.base64().encode(ByteStreams2.hashAndClose((InputStream)input, (HashFunction)Hashing.md5()).asBytes()), (String)md5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadBigFile() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MD5CheckDispatcher());
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        File f = null;
        ByteSourcePayload payload = null;
        try {
            f = File.createTempFile("jclouds", "tmp");
            long length = (new Random().nextInt(32) + 1) * 1024 * 1024;
            TestUtils.randomByteSource().slice(0L, length).copyTo(Files.asByteSink((File)f, (FileWriteMode[])new FileWriteMode[0]));
            ByteSource byteSource = Files.asByteSource((File)f);
            payload = Payloads.newByteSourcePayload((ByteSource)byteSource);
            byte[] digest = byteSource.hash(Hashing.md5()).asBytes();
            String strDigest = BaseEncoding.base64().encode(digest);
            payload.getContentMetadata().setContentMD5(digest);
            payload.getContentMetadata().setContentLength(Long.valueOf(f.length()));
            Multimap<String, String> headers = client.postPayloadAndReturnHeaders("", (Payload)payload);
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)request.getHeader("Content-MD5"), (String)strDigest);
            Assert.assertEquals((Collection)headers.get((Object)"x-Content-MD5"), (Collection)ImmutableList.of((Object)strDigest));
        }
        finally {
            if (payload != null) {
                payload.release();
            }
            if (f != null && f.exists()) {
                f.delete();
            }
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPost() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody("fooPOST"));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.post("", "foo");
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"foo");
            Assert.assertEquals((String)result, (String)"fooPOST");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZeroLengthPost() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse());
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            client.postNothing("");
            Assert.assertEquals((int)server.getRequestCount(), (int)1);
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostIsRetriedOnFailure() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setResponseCode(500), new MockResponse().setBody("fooPOST"));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.post("", "foo");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)result, (String)"fooPOST");
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"foo");
            request = server.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"foo");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostRedirect() throws Exception {
        MockWebServer redirectTarget = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody("fooPOSTREDIRECT"));
        redirectTarget.useHttps(this.sslContext.getSocketFactory(), false);
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setResponseCode(302).setHeader("Location", (Object)redirectTarget.getUrl("/").toString()));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.post("redirect", "foo");
            Assert.assertEquals((String)result, (String)"fooPOSTREDIRECT");
            Assert.assertEquals((int)server.getRequestCount(), (int)1);
            Assert.assertEquals((int)redirectTarget.getRequestCount(), (int)1);
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"foo");
            request = redirectTarget.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"foo");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            redirectTarget.shutdown();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostAsInputStream() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody("fooPOST"));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.postAsInputStream("", "foo");
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"foo");
            Assert.assertEquals((String)result, (String)"fooPOST");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostAsInputStreamDoesNotRetryOnFailure() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setResponseCode(500), new MockResponse());
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            client.postAsInputStream("", "foo");
            Assert.fail((String)"Request should have thrown an exception after a server error");
        }
        catch (Exception expected) {
            Assert.assertEquals((int)server.getRequestCount(), (int)1);
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostBinder() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody("fooPOSTJSON"));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.postJson("", "foo");
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"{\"key\":\"foo\"}");
            Assert.assertEquals((String)result, (String)"fooPOSTJSON");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostContentDisposition() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().addHeader("x-Content-Disposition", (Object)"attachment; filename=photo.jpg"));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        ByteSourcePayload payload = null;
        try {
            ByteSource body = ByteSource.wrap((byte[])"foo".getBytes());
            payload = Payloads.newByteSourcePayload((ByteSource)body);
            payload.getContentMetadata().setContentDisposition("attachment; filename=photo.jpg");
            payload.getContentMetadata().setContentLength(Long.valueOf(body.size()));
            Multimap<String, String> headers = client.postPayloadAndReturnHeaders("", (Payload)payload);
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)request.getHeader("Content-Disposition"), (String)"attachment; filename=photo.jpg");
            Assert.assertEquals((Collection)headers.get((Object)"x-Content-Disposition"), (Collection)ImmutableList.of((Object)"attachment; filename=photo.jpg"));
        }
        finally {
            if (payload != null) {
                payload.release();
            }
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostContentEncoding() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().addHeader("x-Content-Encoding", (Object)"gzip"));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        ByteSourcePayload payload = null;
        try {
            ByteSource body = ByteSource.wrap((byte[])"foo".getBytes());
            payload = Payloads.newByteSourcePayload((ByteSource)body);
            payload.getContentMetadata().setContentEncoding("gzip");
            payload.getContentMetadata().setContentLength(Long.valueOf(body.size()));
            Multimap<String, String> headers = client.postPayloadAndReturnHeaders("", (Payload)payload);
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)request.getHeader("Content-Encoding"), (String)"gzip");
            Assert.assertEquals((Collection)headers.get((Object)"x-Content-Encoding"), (Collection)ImmutableList.of((Object)"gzip"));
        }
        finally {
            if (payload != null) {
                payload.release();
            }
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostContentLanguage() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().addHeader("x-Content-Language", (Object)"mi, en"));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        ByteSourcePayload payload = null;
        try {
            ByteSource body = ByteSource.wrap((byte[])"foo".getBytes());
            payload = Payloads.newByteSourcePayload((ByteSource)body);
            payload.getContentMetadata().setContentLanguage("mi, en");
            payload.getContentMetadata().setContentLength(Long.valueOf(body.size()));
            Multimap<String, String> headers = client.postPayloadAndReturnHeaders("", (Payload)payload);
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)request.getHeader("Content-Language"), (String)"mi, en");
            Assert.assertEquals((Collection)headers.get((Object)"x-Content-Language"), (Collection)ImmutableList.of((Object)"mi, en"));
        }
        finally {
            if (payload != null) {
                payload.release();
            }
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPut() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody("fooPUT"));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.upload("", "foo");
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"foo");
            Assert.assertEquals((String)result, (String)"fooPUT");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutRedirect() throws Exception {
        MockWebServer redirectTarget = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody("fooPUTREDIRECT"));
        redirectTarget.useHttps(this.sslContext.getSocketFactory(), false);
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setResponseCode(302).setHeader("Location", (Object)redirectTarget.getUrl("/").toString()));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.upload("redirect", "foo");
            Assert.assertEquals((String)result, (String)"fooPUTREDIRECT");
            Assert.assertEquals((int)server.getRequestCount(), (int)1);
            Assert.assertEquals((int)redirectTarget.getRequestCount(), (int)1);
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"foo");
            request = redirectTarget.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"foo");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            redirectTarget.shutdown();
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZeroLengthPut() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse());
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            client.putNothing("");
            Assert.assertEquals((int)server.getRequestCount(), (int)1);
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutIsRetriedOnFailure() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setResponseCode(500), new MockResponse().setBody("fooPUT"));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.upload("", "foo");
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
            Assert.assertEquals((String)result, (String)"fooPUT");
            RecordedRequest request = server.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"foo");
            request = server.takeRequest();
            Assert.assertEquals((String)new String(request.getBody(), Charsets.UTF_8), (String)"foo");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHead() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse());
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            Assert.assertTrue((boolean)client.exists(""));
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeadIsRetriedOnServerError() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setResponseCode(500), new MockResponse());
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            Assert.assertTrue((boolean)client.exists(""));
            Assert.assertEquals((int)server.getRequestCount(), (int)2);
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeadFailure() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setResponseCode(404));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            Assert.assertFalse((boolean)client.exists(""));
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAndParseSax() throws Exception {
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody(XML));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            String result = client.downloadAndParse("");
            Assert.assertEquals((String)result, (String)"whoppers");
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterruptThrottledGet() throws Exception {
        long timeoutMillis = 10000L;
        MockWebServer server = BaseHttpCommandExecutorServiceIntegrationTest.mockWebServer(new MockResponse().setBody(XML).throttleBody(XML.length() / 2, timeoutMillis, TimeUnit.MILLISECONDS));
        IntegrationTestClient client = this.client(server.getUrl("/").toString());
        try {
            HttpResponse response = client.invoke(HttpRequest.builder().method("GET").endpoint(server.getUrl("/").toURI()).build());
            InputStream is = response.getPayload().openStream();
            long now = System.currentTimeMillis();
            is.close();
            long diff = System.currentTimeMillis() - now;
            Assert.assertTrue((diff < timeoutMillis / 2L ? 1 : 0) != 0, (String)("expected " + diff + " to be less than " + timeoutMillis / 2L));
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            try {
                server.shutdown();
            }
            catch (IOException ex) {}
        }
    }

    private static class MD5CheckDispatcher
    extends Dispatcher {
        private MD5CheckDispatcher() {
        }

        public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
            try {
                MockResponse response = new MockResponse();
                String expectedMd5 = request.getHeader("Content-MD5");
                ByteSource body = ByteSource.wrap((byte[])request.getBody());
                String realMd5FromRequest = BaseEncoding.base64().encode(body.hash(Hashing.md5()).asBytes());
                boolean matched = expectedMd5.equals(realMd5FromRequest);
                if (matched) {
                    response.addHeader("x-Content-MD5", (Object)realMd5FromRequest);
                } else {
                    response.setResponseCode(500);
                }
                return response;
            }
            catch (IOException ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        }
    }
}

