/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.inject.Module;
import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.Closeable;
import java.util.Properties;
import org.jclouds.http.BaseHttpCommandExecutorServiceIntegrationTest;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.config.JavaUrlHttpCommandExecutorServiceModule;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.rest.HttpClient;
import org.jclouds.util.Closeables2;
import org.jclouds.utils.TestUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
public class JavaUrlHttpCommandExecutorServiceIntegrationTest
extends BaseHttpCommandExecutorServiceIntegrationTest {
    @Override
    protected Module createConnectionModule() {
        return new JavaUrlHttpCommandExecutorServiceModule();
    }

    @Override
    protected void addOverrideProperties(Properties props) {
        props.setProperty("jclouds.max-connections-per-context", "50");
        props.setProperty("jclouds.max-connections-per-host", "0");
        props.setProperty("jclouds.user-threads", "5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void longContentLengthSupported() throws Exception {
        long reallyLongContent = TestUtils.isJava6() ? Integer.MAX_VALUE : Long.MAX_VALUE;
        MockWebServer server = new MockWebServer();
        server.setDispatcher(new Dispatcher(){

            public MockResponse dispatch(RecordedRequest recordedRequest) {
                return new MockResponse();
            }
        });
        server.play();
        HttpClient client = this.api(HttpClient.class, server.getUrl("/").toString());
        StringPayload fakePayload = new StringPayload("");
        fakePayload.getContentMetadata().setContentLength(Long.valueOf(reallyLongContent));
        try {
            try {
                client.post(server.getUrl("/").toURI(), (Payload)fakePayload);
                Assert.fail((String)"Should have errored since we didn't sent that much data!");
            }
            catch (HttpResponseException expected) {
                // empty catch block
            }
            Assert.assertEquals((String)server.takeRequest().getHeader("Content-Length"), (String)String.valueOf(reallyLongContent));
        }
        finally {
            Closeables2.closeQuietly((Closeable)client);
            server.shutdown();
        }
    }
}

