/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.logging.Logger;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true)
public class WireTest {
    public HttpWire setUp() throws Exception {
        BufferLogger bufferLogger = new BufferLogger();
        HttpWire wire = new HttpWire();
        wire.wireLog = bufferLogger;
        return wire;
    }

    public HttpWire setUpSynch() throws Exception {
        BufferLogger bufferLogger = new BufferLogger();
        HttpWire wire = new HttpWire();
        wire.wireLog = bufferLogger;
        return wire;
    }

    public void testInputInputStream() throws Exception {
        HttpWire wire = this.setUp();
        InputStream in = wire.input((InputStream)new ByteArrayInputStream("foo".getBytes()));
        String compare = Strings2.toStringAndClose((InputStream)in);
        Thread.sleep(100L);
        Assert.assertEquals((String)compare, (String)"foo");
        Assert.assertEquals((String)((BufferLogger)wire.getWireLog()).buff.toString(), (String)"<< \"foo\"");
    }

    public void testInputInputStreamSynch() throws Exception {
        HttpWire wire = this.setUpSynch();
        InputStream in = wire.input((InputStream)new ByteArrayInputStream("foo".getBytes()));
        String compare = Strings2.toStringAndClose((InputStream)in);
        Assert.assertEquals((String)compare, (String)"foo");
        Assert.assertEquals((String)((BufferLogger)wire.getWireLog()).buff.toString(), (String)"<< \"foo\"");
    }

    public void testOutputInputStream() throws Exception {
        HttpWire wire = this.setUp();
        InputStream in = (InputStream)wire.output((Object)new ByteArrayInputStream("foo".getBytes()));
        String compare = Strings2.toStringAndClose((InputStream)in);
        Thread.sleep(100L);
        Assert.assertEquals((String)compare, (String)"foo");
        Assert.assertEquals((String)((BufferLogger)wire.getWireLog()).buff.toString(), (String)">> \"foo\"");
    }

    public void testOutputBytes() throws Exception {
        HttpWire wire = this.setUp();
        wire.output((Object)"foo".getBytes());
        Assert.assertEquals((String)((BufferLogger)wire.getWireLog()).buff.toString(), (String)">> \"foo\"");
    }

    public void testOutputString() throws Exception {
        HttpWire wire = this.setUp();
        wire.output((Object)"foo");
        Assert.assertEquals((String)((BufferLogger)wire.getWireLog()).buff.toString(), (String)">> \"foo\"");
    }

    @Test
    public void testInputPayload() throws Exception {
        HttpWire wire = this.setUp();
        StringPayload payload = new StringPayload("foo");
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("foo").endpoint("http://foo").payload((Payload)payload)).build();
        wire.input((PayloadEnclosing)request);
        BufferLogger wireLog = (BufferLogger)wire.getWireLog();
        Assert.assertEquals((String)wireLog.buff.toString(), (String)"<< \"foo\"", (String)"Expected payload to be printed in logs");
        wireLog.buff.setLength(0);
        payload.setSensitive(true);
        request = ((HttpRequest.Builder)HttpRequest.builder().method("foo").endpoint("http://foo").payload((Payload)payload)).build();
        wire.input((PayloadEnclosing)request);
        Assert.assertNotEquals((Object)wireLog.buff.toString(), (Object)"<< \"foo\"", (String)"Expected payload to NOT be printed in logs");
        wireLog.buff.setLength(0);
        wire.logSensitiveInformation = true;
        request = ((HttpRequest.Builder)HttpRequest.builder().method("foo").endpoint("http://foo").payload((Payload)payload)).build();
        wire.input((PayloadEnclosing)request);
        Assert.assertEquals((String)wireLog.buff.toString(), (String)"<< \"foo\"", (String)"Expected payload to be printed in logs");
    }

    @Test
    public void testOutputPayload() throws Exception {
        HttpWire wire = this.setUp();
        StringPayload payload = new StringPayload("foo");
        HttpRequest request = ((HttpRequest.Builder)HttpRequest.builder().method("foo").endpoint("http://foo").payload((Payload)payload)).build();
        wire.output((PayloadEnclosing)request);
        BufferLogger wireLog = (BufferLogger)wire.getWireLog();
        Assert.assertEquals((String)wireLog.buff.toString(), (String)">> \"foo\"", (String)"Expected payload to be printed in logs");
        wireLog.buff.setLength(0);
        payload.setSensitive(true);
        request = ((HttpRequest.Builder)HttpRequest.builder().method("foo").endpoint("http://foo").payload((Payload)payload)).build();
        wire.output((PayloadEnclosing)request);
        Assert.assertNotEquals((Object)wireLog.buff.toString(), (Object)">> \"foo\"", (String)"Expected payload to NOT be printed in logs");
        wireLog.buff.setLength(0);
        wire.logSensitiveInformation = true;
        request = ((HttpRequest.Builder)HttpRequest.builder().method("foo").endpoint("http://foo").payload((Payload)payload)).build();
        wire.output((PayloadEnclosing)request);
        Assert.assertEquals((String)wireLog.buff.toString(), (String)">> \"foo\"", (String)"Expected payload to be printed in logs");
    }

    class BufferLogger
    implements Logger {
        StringBuilder buff = new StringBuilder();

        BufferLogger() {
        }

        public void debug(String message, Object ... args) {
            this.buff.append(message);
        }

        public void error(String message, Object ... args) {
        }

        public void error(Throwable throwable, String message, Object ... args) {
        }

        public String getCategory() {
            return null;
        }

        public void info(String message, Object ... args) {
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public boolean isErrorEnabled() {
            return false;
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return false;
        }

        public void trace(String message, Object ... args) {
        }

        public void warn(String message, Object ... args) {
        }

        public void warn(Throwable throwable, String message, Object ... args) {
        }
    }
}

