/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.net.MediaType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.easymock.EasyMock;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.FilePayload;
import org.jclouds.io.payloads.MultipartForm;
import org.jclouds.io.payloads.Part;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="http.MultipartFormTest")
public class MultipartFormTest {
    String boundary = "------------------------------c88555ffd14e";

    public void testSinglePart() throws IOException {
        StringBuilder builder = new StringBuilder();
        this.addData(this.boundary, "hello", builder);
        builder.append("--").append(this.boundary).append("--").append("\r\n");
        String expects = builder.toString();
        Assert.assertEquals((int)expects.length(), (int)199);
        MultipartForm multipartForm = new MultipartForm(this.boundary, new Part[]{this.newPart("hello")});
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)multipartForm.openStream()), (String)expects);
        Assert.assertEquals((Object)multipartForm.getContentMetadata().getContentLength(), (Object)199L);
    }

    private Part newPart(String data) {
        return Part.create((String)"file", (Payload)new MockFilePayload(data), (Part.PartOptions)new Part.PartOptions().contentType(MediaType.PLAIN_TEXT_UTF_8.withoutParameters().toString()));
    }

    private void addData(String boundary, String data, StringBuilder builder) {
        builder.append("--").append(boundary).append("\r\n");
        builder.append("Content-Disposition").append(": ").append("form-data; name=\"file\"; filename=\"testfile.txt\"").append("\r\n");
        builder.append("Content-Type").append(": ").append("text/plain").append("\r\n");
        builder.append("\r\n");
        builder.append(data).append("\r\n");
    }

    public void testMultipleParts() throws IOException {
        StringBuilder builder = new StringBuilder();
        this.addData(this.boundary, "hello", builder);
        this.addData(this.boundary, "goodbye", builder);
        builder.append("--").append(this.boundary).append("--").append("\r\n");
        String expects = builder.toString();
        Assert.assertEquals((int)expects.length(), (int)352);
        MultipartForm multipartForm = new MultipartForm(this.boundary, new Part[]{this.newPart("hello"), this.newPart("goodbye")});
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)multipartForm.openStream()), (String)expects);
        assert (multipartForm.isRepeatable());
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)multipartForm.openStream()), (String)expects);
        Assert.assertEquals((Object)multipartForm.getContentMetadata().getContentLength(), (Object)352L);
    }

    public static class MockFilePayload
    extends FilePayload {
        private final StringPayload realPayload;

        public MockFilePayload(String content) {
            super(MockFilePayload.createMockFile(content));
            this.realPayload = Payloads.newStringPayload((String)content);
        }

        private static File createMockFile(String content) {
            File file = (File)EasyMock.createMock(File.class);
            EasyMock.expect((Object)file.length()).andReturn((Object)content.length());
            EasyMock.expect((Object)file.exists()).andReturn((Object)true);
            EasyMock.expect((Object)file.getName()).andReturn((Object)"testfile.txt");
            EasyMock.replay((Object[])new Object[]{file});
            return file;
        }

        public InputStream openStream() throws IOException {
            return this.realPayload.openStream();
        }

        public boolean isRepeatable() {
            return this.realPayload.isRepeatable();
        }
    }
}

