/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.lifecycle.config;

import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.CountDownLatch;
import javax.annotation.PostConstruct;
import org.easymock.EasyMock;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.lifecycle.Closer;
import org.jclouds.lifecycle.config.LifeCycleModule;
import org.testng.annotations.Test;

@Test
public class LifeCycleModuleTest {
    @Test
    void testBindsExecutor() {
        Injector i = this.createInjector();
        assert (i.getInstance(Key.get(ListeningExecutorService.class, (Annotation)Names.named((String)"jclouds.user-threads"))) != null);
    }

    private Injector createInjector() {
        Injector i = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.user-threads")).to(1);
            }
        }, new LifeCycleModule(), new ExecutorServiceModule()});
        ((ExecutionList)i.getInstance(ExecutionList.class)).execute();
        return i;
    }

    @Test
    void testBindsCloser() {
        Injector i = this.createInjector();
        assert (i.getInstance(Closer.class) != null);
        assert (((Closer)i.getInstance(Closer.class)).getState() == Closer.State.AVAILABLE);
    }

    @Test
    void testCloserClosesExecutor() throws IOException {
        Injector i = this.createInjector();
        ListeningExecutorService executor = (ListeningExecutorService)i.getInstance(Key.get(ListeningExecutorService.class, (Annotation)Names.named((String)"jclouds.user-threads")));
        assert (!executor.isShutdown());
        Closer closer = (Closer)i.getInstance(Closer.class);
        assert (closer.getState() == Closer.State.AVAILABLE);
        closer.close();
        assert (executor.isShutdown());
        assert (closer.getState() == Closer.State.DONE);
    }

    @Test
    void testCloserPreDestroyOrder() throws IOException {
        Injector i = this.createInjector();
        ListeningExecutorService userExecutor = (ListeningExecutorService)i.getInstance(Key.get(ListeningExecutorService.class, (Annotation)Names.named((String)"jclouds.user-threads")));
        assert (!userExecutor.isShutdown());
        Closer closer = (Closer)i.getInstance(Closer.class);
        assert (closer.getState() == Closer.State.AVAILABLE);
        closer.close();
        assert (userExecutor.isShutdown());
        assert (closer.getState() == Closer.State.DONE);
    }

    @Test
    void testPostConstruct() {
        Injector i = this.createInjector().createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(PostConstructable.class);
            }
        }});
        PostConstructable postConstructable = (PostConstructable)i.getInstance(PostConstructable.class);
        assert (postConstructable.isStarted);
    }

    @Test
    void testCloserClosingState() throws InterruptedException {
        Injector i = this.createInjector();
        final Closer closer = (Closer)i.getInstance(Closer.class);
        final CountDownLatch closeDone = new CountDownLatch(1);
        final CountDownLatch closeStart = new CountDownLatch(1);
        closer.addToClose(new Closeable(){

            @Override
            public void close() throws IOException {
                block3: {
                    try {
                        closeStart.countDown();
                        assert (closer.getState() == Closer.State.PROCESSING);
                        closeDone.await();
                    }
                    catch (InterruptedException e) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError((Object)e.getMessage());
                    }
                }
            }
        });
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        closer.close();
                    }
                    catch (IOException e) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError((Object)e.getMessage());
                    }
                }
            }
        });
        thread.start();
        closeStart.await();
        assert (closer.getState() == Closer.State.PROCESSING);
        closeDone.countDown();
        thread.join();
        assert (closer.getState() == Closer.State.DONE);
    }

    @Test
    void testCloserCallOneClose() throws IOException, InterruptedException {
        Injector i = this.createInjector();
        final Closer closer = (Closer)i.getInstance(Closer.class);
        Closeable closeable = (Closeable)EasyMock.createStrictMock(Closeable.class);
        closeable.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{closeable});
        closer.addToClose(closeable);
        Runnable closeContext = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        closer.close();
                    }
                    catch (IOException e) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError((Object)e.getMessage());
                    }
                }
            }
        };
        Thread thread1 = new Thread(closeContext);
        Thread thread2 = new Thread(closeContext);
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        EasyMock.verify((Object[])new Object[]{closeable});
        assert (closer.getState() == Closer.State.DONE);
    }

    static class PostConstructable {
        boolean isStarted;

        PostConstructable() {
        }

        @PostConstruct
        void start() {
            this.isStarted = true;
        }
    }
}

