/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.Map;
import org.jclouds.location.suppliers.LocationIdToIso3166CodesSupplier;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="ProvideIso3166CodesByLocationIdViaPropertiesTest")
public class ProvideIso3166CodesByLocationIdViaPropertiesTest {
    public void testEmptyWhenNoLocationsBound() {
        LocationIdToIso3166CodesSupplier fn = this.createWithValue((ImmutableMap<String, String>)ImmutableMap.of());
        Assert.assertEquals((Map)((Map)fn.get()), (Map)ImmutableMap.of());
    }

    public void testEmptyWhenRegionsAndZonesBoundButNoIsoCodes() {
        LocationIdToIso3166CodesSupplier fn = this.createWithValue((ImmutableMap<String, String>)ImmutableMap.of((Object)"jclouds.regions", (Object)"us-east", (Object)"jclouds.zones", (Object)"us-easta"));
        Assert.assertEquals((Map)((Map)fn.get()), (Map)ImmutableMap.of());
    }

    public void testIsoCodesWhenRegionsAndZonesBoundWithIsoCodes() {
        LocationIdToIso3166CodesSupplier fn = this.createWithValue((ImmutableMap<String, String>)ImmutableMap.of((Object)"jclouds.regions", (Object)"us-east", (Object)"jclouds.region.us-east.iso3166-codes", (Object)"US", (Object)"jclouds.zones", (Object)"us-easta", (Object)"jclouds.zone.us-easta.iso3166-codes", (Object)"US-CA"));
        Assert.assertEquals((Map)Maps.transformValues((Map)((Map)fn.get()), (Function)Suppliers.supplierFunction()), (Map)ImmutableMap.of((Object)"us-east", (Object)ImmutableSet.of((Object)"US"), (Object)"us-easta", (Object)ImmutableSet.of((Object)"US-CA")));
    }

    private LocationIdToIso3166CodesSupplier createWithValue(final ImmutableMap<String, String> value) {
        LocationIdToIso3166CodesSupplier fn = (LocationIdToIso3166CodesSupplier)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            @Provides
            Function<Predicate<String>, Map<String, String>> provide() {
                return new Function<Predicate<String>, Map<String, String>>(){

                    public Map<String, String> apply(Predicate<String> input) {
                        return Maps.filterKeys((Map)value, input);
                    }
                };
            }

            protected void configure() {
            }
        }}).getInstance(LocationIdToIso3166CodesSupplier.class);
        return fn;
    }
}

