/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.providers.config;

import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.reflect.TypeToken;
import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.Context;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.IntegrationTestClient;
import org.jclouds.internal.FilterStringsBoundToInjectorByName;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.config.BindProviderMetadataContextAndCredentials;
import org.jclouds.rest.annotations.Api;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.BuildVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindProviderMetadataContextAndCredentialsTest")
public class BindProviderMetadataContextAndCredentialsTest {
    @Test
    public void testExpectedBindingsWhenCredentialIsNotNull() {
        ProviderMetadata md = AnonymousProviderMetadata.forApiOnEndpoint(IntegrationTestClient.class, (String)"http://localhost");
        Supplier creds = Suppliers.ofInstance((Object)LoginCredentials.builder().user("user").password("password").build());
        ExpectedBindings bindings = (ExpectedBindings)Guice.createInjector((Module[])new Module[]{new BindProviderMetadataContextAndCredentials(md, creds)}).getInstance(ExpectedBindings.class);
        Assert.assertEquals((String)((ExpectedBindings)bindings).creds.identity, (String)"user");
        Assert.assertEquals((String)((ExpectedBindings)bindings).creds.credential, (String)"password");
    }

    @Test
    public void testExpectedBindingsWhenCredentialIsNull() {
        ProviderMetadata md = AnonymousProviderMetadata.forApiOnEndpoint(IntegrationTestClient.class, (String)"http://localhost");
        Supplier creds = Suppliers.ofInstance((Object)LoginCredentials.builder().user("user").build());
        ExpectedBindings bindings = (ExpectedBindings)Guice.createInjector((Module[])new Module[]{new BindProviderMetadataContextAndCredentials(md, creds)}).getInstance(ExpectedBindings.class);
        Assert.assertEquals((String)((ExpectedBindings)bindings).creds.identity, (String)"user");
        Assert.assertEquals((String)((ExpectedBindings)bindings).creds.credential, null);
    }

    @Test
    public void testExpectedBindingsWhenBuildVersionAbsent() {
        ProviderMetadata md = AnonymousProviderMetadata.forApiOnEndpoint(IntegrationTestClient.class, (String)"http://localhost");
        ApiMetadata apiMd = md.getApiMetadata().toBuilder().buildVersion(null).build();
        md = md.toBuilder().apiMetadata(apiMd).build();
        Supplier creds = Suppliers.ofInstance((Object)LoginCredentials.builder().user("user").build());
        ExpectedBindings bindings = (ExpectedBindings)Guice.createInjector((Module[])new Module[]{new BindProviderMetadataContextAndCredentials(md, creds)}).getInstance(ExpectedBindings.class);
        Assert.assertEquals((String)bindings.buildVersion, null);
    }

    @Test
    public void testProviderOverridesApiMetadataProperty() {
        ProviderMetadata md = AnonymousProviderMetadata.forApiOnEndpoint(IntegrationTestClient.class, (String)"http://localhost");
        Properties defaultProps = md.getDefaultProperties();
        defaultProps.setProperty("jclouds.session-interval", "2147483647");
        md = md.toBuilder().defaultProperties(defaultProps).build();
        Supplier creds = Suppliers.ofInstance((Object)LoginCredentials.builder().user("user").build());
        int session = (Integer)Guice.createInjector((Module[])new Module[]{new BindProviderMetadataContextAndCredentials(md, creds)}).getInstance(Key.get(Integer.TYPE, (Annotation)Names.named((String)"jclouds.session-interval")));
        Assert.assertEquals((int)session, (int)Integer.MAX_VALUE);
    }

    private static class ExpectedBindings {
        private final javax.inject.Provider<Context> backend;
        private final ProviderMetadata providerMetadata;
        private final Credentials creds;
        private final String providerId;
        private final Set<String> iso3166Codes;
        private final String apiId;
        private final String apiVersion;
        private final String buildVersion;

        @Inject
        private ExpectedBindings(@Provider javax.inject.Provider<Context> backend, ProviderMetadata providerMetadata, @Provider Supplier<Credentials> creds, @Provider String providerId, @Iso3166 Set<String> iso3166Codes, @Api String apiId, @ApiVersion String apiVersion, @Nullable @BuildVersion String buildVersion, @Provider TypeToken<? extends Context> backendToken, FilterStringsBoundToInjectorByName filter) {
            this.backend = backend;
            Assert.assertEquals(backendToken, (Object)providerMetadata.getApiMetadata().getContext());
            this.providerMetadata = providerMetadata;
            Properties props = new Properties();
            props.putAll((Map<?, ?>)filter.apply(Predicates.alwaysTrue()));
            Properties expected = new Properties();
            expected.putAll((Map<?, ?>)providerMetadata.getApiMetadata().getDefaultProperties());
            expected.putAll((Map<?, ?>)providerMetadata.getDefaultProperties());
            Assert.assertEquals((Map)props, (Map)expected);
            this.creds = (Credentials)creds.get();
            this.providerId = providerId;
            Assert.assertEquals((String)providerId, (String)providerMetadata.getId());
            this.iso3166Codes = iso3166Codes;
            Assert.assertEquals(iso3166Codes, (Set)providerMetadata.getIso3166Codes());
            this.apiId = apiId;
            Assert.assertEquals((String)apiId, (String)providerMetadata.getApiMetadata().getId());
            this.apiVersion = apiVersion;
            Assert.assertEquals((String)apiVersion, (String)providerMetadata.getApiMetadata().getVersion());
            this.buildVersion = buildVersion;
            Assert.assertEquals((String)buildVersion, (String)((String)providerMetadata.getApiMetadata().getBuildVersion().orNull()));
        }
    }
}

