/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.annotationparsing;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.io.Closeable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.xml.bind.annotation.XmlRootElement;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.annotations.JAXBResponseParser;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.internal.BaseRestApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="JAXBResponseParserAnnotationExpectTest")
public class JAXBResponseParserAnnotationExpectTest
extends BaseRestApiExpectTest<TestJAXBApi> {
    @Test
    public void testJAXBResponseParserAnnotationWithoutValue() throws SecurityException, NoSuchMethodException {
        TestJAXBApi api = (TestJAXBApi)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint("http://mock/jaxb/annotation").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload("<test><elem>Hello World</elem></test>")).build());
        TestJAXBDomain result = api.jaxbGetWithAnnotation();
        Assert.assertEquals((String)result.getElem(), (String)"Hello World");
    }

    @Test
    public void testJAXBResponseParserAnnotationWithCustomValue() throws SecurityException, NoSuchMethodException {
        TestJAXBApi api = (TestJAXBApi)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint("http://mock/jaxb/custom").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload("<test><elem>Hello World</elem></test>")).build());
        Object result = api.jaxbGetWithAnnotationAndCustomClass();
        Assert.assertTrue((boolean)(result instanceof TestJAXBDomain));
        Assert.assertEquals((String)((TestJAXBDomain)TestJAXBDomain.class.cast(result)).getElem(), (String)"Hello World");
    }

    @Test
    public void testJAXBResponseParserAnnotationWithAcceptHeader() throws SecurityException, NoSuchMethodException {
        TestJAXBApi api = (TestJAXBApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://mock/jaxb/header").addHeader("Accept", new String[]{"application/xml"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload("<test><elem>Hello World</elem></test>")).build());
        TestJAXBDomain result = api.jaxbGetWithAcceptHeader();
        Assert.assertEquals((String)result.getElem(), (String)"Hello World");
    }

    @Test
    public void testJAXBResponseParserAnnotationWithTransformer() throws SecurityException, NoSuchMethodException {
        TestJAXBApi api = (TestJAXBApi)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint("http://mock/jaxb/transformer").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload("<test><elem>Hello World</elem></test>")).build());
        String result = api.jaxbGetWithTransformer();
        Assert.assertEquals((String)result, (String)"TestJAXBDomain [elem=Hello World]");
    }

    @Override
    public ProviderMetadata createProviderMetadata() {
        return AnonymousProviderMetadata.forApiOnEndpoint(TestJAXBApi.class, (String)"http://mock");
    }

    private static class ToString
    implements Function<Object, String> {
        private ToString() {
        }

        public String apply(Object input) {
            return (String)Functions.toStringFunction().apply(input);
        }
    }

    public static interface TestJAXBApi
    extends Closeable {
        @GET
        @Path(value="/jaxb/annotation")
        @JAXBResponseParser
        public TestJAXBDomain jaxbGetWithAnnotation();

        @GET
        @Path(value="/jaxb/custom")
        @JAXBResponseParser(value=TestJAXBDomain.class)
        public Object jaxbGetWithAnnotationAndCustomClass();

        @GET
        @Path(value="/jaxb/header")
        @Consumes(value={"application/xml"})
        public TestJAXBDomain jaxbGetWithAcceptHeader();

        @GET
        @Path(value="/jaxb/transformer")
        @JAXBResponseParser(value=TestJAXBDomain.class)
        @Transform(value=ToString.class)
        public String jaxbGetWithTransformer();
    }

    @XmlRootElement(name="test")
    public static class TestJAXBDomain {
        private String elem;

        public String getElem() {
            return this.elem;
        }

        public void setElem(String elem) {
            this.elem = elem;
        }

        public String toString() {
            return "TestJAXBDomain [elem=" + this.elem + "]";
        }
    }
}

