/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.util.List;
import java.util.Properties;
import javax.inject.Named;
import org.jclouds.Fallback;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpResponse;
import org.jclouds.internal.FilterStringsBoundToInjectorByName;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.config.ReadAnnotationsAndProperties;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true)
public class ReadAnnotationsAndPropertiesTest {
    private Invocation asyncGet;
    private Invocation asyncNamedGet;
    private Fallback<Object> defaultFallback;

    @BeforeClass
    void setupInvocations() throws SecurityException, NoSuchMethodException {
        this.asyncGet = Invocation.create((Invokable)Reflection2.method(ThingApi.class, (String)"get", (Class[])new Class[0]), (List)ImmutableList.of());
        this.asyncNamedGet = Invocation.create((Invokable)Reflection2.method(ThingApi.class, (String)"namedGet", (Class[])new Class[0]), (List)ImmutableList.of());
        this.defaultFallback = new Fallbacks.NullOnNotFoundOr404();
    }

    public void testInvocationsSetDefaultTimeoutOnAsyncMethods() throws Exception {
        final Properties props = new Properties();
        props.setProperty("jclouds.timeouts.default", "250");
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)props);
            }
        }});
        ReadAnnotationsAndProperties config = new ReadAnnotationsAndProperties(injector, (Function)new FilterStringsBoundToInjectorByName(injector), this.defaultFallback);
        Assert.assertEquals((Object)config.getTimeoutNanos(this.asyncGet), (Object)Optional.of((Object)250000000L));
        Assert.assertEquals((Object)config.getTimeoutNanos(this.asyncNamedGet), (Object)Optional.of((Object)250000000L));
    }

    public void testNamedInvocationGetsTimeoutOverrideOnAsyncMethods() throws Exception {
        final Properties props = new Properties();
        props.setProperty("jclouds.timeouts.default", "50");
        props.setProperty("jclouds.timeouts.ThingApi", "100");
        props.setProperty("jclouds.timeouts.ns:get", "250");
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Properties)props);
            }
        }});
        ReadAnnotationsAndProperties config = new ReadAnnotationsAndProperties(injector, (Function)new FilterStringsBoundToInjectorByName(injector), this.defaultFallback);
        Assert.assertEquals((Object)config.getTimeoutNanos(this.asyncNamedGet), (Object)Optional.of((Object)250000000L));
    }

    public void testNamingConventionOfUnnamedMethods() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        ReadAnnotationsAndProperties config = new ReadAnnotationsAndProperties(injector, (Function)new FilterStringsBoundToInjectorByName(injector), this.defaultFallback);
        Assert.assertEquals((String)config.getCommandName(this.asyncGet), (String)"ThingApi.get");
    }

    public void testNamingConventionOfNamedAsyncMethods() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        ReadAnnotationsAndProperties config = new ReadAnnotationsAndProperties(injector, (Function)new FilterStringsBoundToInjectorByName(injector), this.defaultFallback);
        Assert.assertEquals((String)config.getCommandName(this.asyncNamedGet), (String)"ns:get");
    }

    public void testFallbackOverride() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[0]);
        ReadAnnotationsAndProperties config = new ReadAnnotationsAndProperties(injector, (Function)new FilterStringsBoundToInjectorByName(injector), this.defaultFallback);
        Assert.assertEquals(config.getFallback(this.asyncNamedGet).getClass(), Fallbacks.FalseOnNotFoundOr404.class);
        Assert.assertEquals((Object)config.getFallback(this.asyncGet), this.defaultFallback);
    }

    public static interface ThingApi {
        public HttpResponse get();

        @Named(value="ns:get")
        @org.jclouds.rest.annotations.Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
        public HttpResponse namedGet();
    }
}

