/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public abstract class BaseRestAnnotationProcessingTest<T>
extends BaseRestApiTest {
    protected RestAnnotationProcessor processor;
    protected String identity = "identity";
    protected String credential = "credential";

    protected abstract void checkFilters(HttpRequest var1);

    protected Module createModule() {
        return new Module(){

            public void configure(Binder binder) {
            }
        };
    }

    @BeforeClass
    protected void setupFactory() throws IOException {
        this.injector = this.createInjector();
        this.parserFactory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        this.processor = (RestAnnotationProcessor)this.injector.getInstance(RestAnnotationProcessor.class);
    }

    protected ProviderMetadata createProviderMetadata() {
        return null;
    }

    protected ApiMetadata createApiMetadata() {
        return null;
    }

    protected Injector createInjector() {
        ProviderMetadata pm = this.createProviderMetadata();
        ContextBuilder builder = pm != null ? ContextBuilder.newBuilder((ProviderMetadata)pm) : ContextBuilder.newBuilder((ApiMetadata)((ApiMetadata)ApiMetadata.class.cast(Preconditions.checkNotNull((Object)this.createApiMetadata(), (Object)"either createApiMetadata or createProviderMetadata must be overridden"))));
        return builder.credentials(this.identity, this.credential).modules((Iterable)ImmutableSet.of((Object)((Object)new BaseRestApiTest.MockModule()), (Object)new NullLoggingModule(), (Object)this.createModule())).overrides(this.setupProperties()).buildInjector();
    }

    protected Properties setupProperties() {
        return new Properties();
    }
}

