/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true)
public class Predicates2Test {
    public static int SLOW_BUILD_SERVER_GRACE = 250;
    public static int EARLY_RETURN_GRACE = 10;
    private Stopwatch stopwatch;

    @BeforeMethod
    public void setUp() {
        this.stopwatch = Stopwatch.createUnstarted();
    }

    @Test
    void testRetryReturnsFalseOnIllegalStateExeception() {
        this.ensureImmediateReturnFor(new IllegalStateException());
    }

    @Test
    void testRetryReturnsFalseOnExecutionException() {
        this.ensureImmediateReturnFor(new ExecutionException(new Exception("Simulated cause")));
    }

    @Test
    void testRetryReturnsFalseOnTimeoutException() {
        this.ensureImmediateReturnFor(new TimeoutException("Simulating exception"));
    }

    @Test(expectedExceptions={RuntimeException.class})
    void testRetryPropagatesOnException() {
        this.ensureImmediateReturnFor(new Exception("Simulating exception"));
    }

    private void ensureImmediateReturnFor(final Exception ex) {
        Predicate predicate = Predicates2.retry((Predicate)new Predicate<Supplier<String>>(){

            public boolean apply(Supplier<String> input) {
                return "goo".equals(input.get());
            }
        }, (long)3L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.stopwatch.start();
        Assert.assertFalse((boolean)predicate.apply((Object)new Supplier<String>(){

            public String get() {
                throw new RuntimeException(ex);
            }
        }));
        long duration = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        Predicates2Test.assertOrdered(duration, SLOW_BUILD_SERVER_GRACE);
    }

    @Test
    void testRetryAlwaysFalseMillis() {
        RepeatedAttemptsPredicate rawPredicate = new RepeatedAttemptsPredicate(Integer.MAX_VALUE);
        Predicate predicate = Predicates2.retry((Predicate)rawPredicate, (long)3L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.stopwatch.start();
        Assert.assertFalse((boolean)predicate.apply((Object)""));
        long duration = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        Predicates2Test.assertOrdered(3000 - EARLY_RETURN_GRACE, duration, 3000 + SLOW_BUILD_SERVER_GRACE);
        Predicates2Test.assertCallTimes(rawPredicate.callTimes, 0, 1000, 2500, 3000);
    }

    @Test
    void testRetryFirstTimeTrue() {
        RepeatedAttemptsPredicate rawPredicate = new RepeatedAttemptsPredicate(1);
        Predicate predicate = Predicates2.retry((Predicate)rawPredicate, (long)4L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.stopwatch.start();
        Assert.assertTrue((boolean)predicate.apply((Object)""));
        long duration = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        Predicates2Test.assertOrdered(0L, duration, 0 + SLOW_BUILD_SERVER_GRACE);
        Predicates2Test.assertCallTimes(rawPredicate.callTimes, 0);
    }

    @Test
    void testRetryWillRunOnceOnNegativeTimeout() {
        RepeatedAttemptsPredicate rawPredicate = new RepeatedAttemptsPredicate(1);
        Predicate predicate = Predicates2.retry((Predicate)rawPredicate, (long)-1L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.stopwatch.start();
        Assert.assertTrue((boolean)predicate.apply((Object)""));
        long duration = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        Predicates2Test.assertOrdered(0L, duration, 0 + SLOW_BUILD_SERVER_GRACE);
        Predicates2Test.assertCallTimes(rawPredicate.callTimes, 0);
    }

    @Test
    void testRetryThirdTimeTrue() {
        RepeatedAttemptsPredicate rawPredicate = new RepeatedAttemptsPredicate(3);
        Predicate predicate = Predicates2.retry((Predicate)rawPredicate, (long)4L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.stopwatch.start();
        Assert.assertTrue((boolean)predicate.apply((Object)""));
        long duration = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        Predicates2Test.assertOrdered(2500 - EARLY_RETURN_GRACE, duration, 2500 + SLOW_BUILD_SERVER_GRACE);
        Predicates2Test.assertCallTimes(rawPredicate.callTimes, 0, 1000, 2500);
    }

    @Test
    void testRetryThirdTimeTrueLimitedMaxInterval() {
        RepeatedAttemptsPredicate rawPredicate = new RepeatedAttemptsPredicate(3);
        Predicate predicate = Predicates2.retry((Predicate)rawPredicate, (long)3L, (long)1L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.stopwatch.start();
        Assert.assertTrue((boolean)predicate.apply((Object)""));
        long duration = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        Predicates2Test.assertOrdered(2000 - EARLY_RETURN_GRACE, duration, 2000 + SLOW_BUILD_SERVER_GRACE);
        Predicates2Test.assertCallTimes(rawPredicate.callTimes, 0, 1000, 2000);
    }

    @Test(enabled=false)
    public static void assertCallTimes(List<Long> actual, Integer ... expected) {
        Assert.assertEquals((int)actual.size(), (int)expected.length, (String)("actual=" + actual));
        for (int i = 0; i < expected.length; ++i) {
            long callTime = actual.get(i);
            Predicates2Test.assertOrdered(expected[i] - EARLY_RETURN_GRACE, callTime, expected[i] + SLOW_BUILD_SERVER_GRACE);
        }
    }

    private static void assertOrdered(long ... values) {
        long prevVal = values[0];
        for (long val : values) {
            if (val >= prevVal) continue;
            Assert.fail((String)String.format("%s should be ordered", Arrays.toString(values)));
        }
    }

    public static class RepeatedAttemptsPredicate
    implements Predicate<String> {
        final List<Long> callTimes = Lists.newArrayList();
        private final int succeedOnAttempt;
        private final Stopwatch stopwatch;
        private int count = 0;

        RepeatedAttemptsPredicate(int succeedOnAttempt) {
            this.succeedOnAttempt = succeedOnAttempt;
            this.stopwatch = Stopwatch.createUnstarted();
            this.stopwatch.start();
        }

        public boolean apply(String input) {
            this.callTimes.add(this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return ++this.count == this.succeedOnAttempt;
        }
    }
}

