/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.utils;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public class TestUtils {
    public static boolean isMacOSX() {
        String osName = System.getProperty("os.name");
        return osName.contains("OS X");
    }

    public static boolean isJava6() {
        return System.getProperty("java.version", "").contains("1.6.");
    }

    public static ByteSource randomByteSource() {
        return TestUtils.randomByteSource(0L);
    }

    public static ByteSource randomByteSource(long seed) {
        return new RandomByteSource(seed);
    }

    private static class RandomInputStream
    extends InputStream {
        private final Random random;
        private boolean closed = false;

        RandomInputStream(long seed) {
            this.random = new Random(seed);
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.closed) {
                throw new IOException("Stream already closed");
            }
            return (byte)this.random.nextInt();
        }

        @Override
        public synchronized int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                b[off + i] = (byte)this.read();
            }
            return len;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }
    }

    private static class RandomByteSource
    extends ByteSource {
        private final long seed;

        RandomByteSource(long seed) {
            this.seed = seed;
        }

        public InputStream openStream() {
            return new RandomInputStream(this.seed);
        }
    }
}

