/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.utils;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.jclouds.util.Closeables2;
import org.jclouds.utils.TestUtils;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TestUtilsTest")
public class TestUtilsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomByteSource() throws Exception {
        ByteSource byteSource = TestUtils.randomByteSource();
        InputStream is1 = null;
        InputStream is2 = null;
        try {
            is1 = byteSource.openStream();
            is2 = byteSource.openStream();
            byte[] bytes = new byte[16];
            ByteStreams.readFully((InputStream)is1, (byte[])bytes);
            for (byte b : bytes) {
                Assertions.assertThat((byte)b).isEqualTo((byte)is2.read());
            }
        }
        finally {
            Closeables2.closeQuietly((Closeable)is1);
            Closeables2.closeQuietly((Closeable)is2);
        }
    }
}

