/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.proxy.internal;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import java.net.Proxy;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.proxy.ProxyConfig;

@Singleton
public class GuiceProxyConfig
implements ProxyConfig {
    @Inject(optional=true)
    @Named(value="jclouds.use-system-proxy")
    private boolean systemProxies = Boolean.parseBoolean(System.getProperty("java.net.useSystemProxies", "false"));
    @Inject(optional=true)
    @Named(value="jclouds.proxy-host")
    private String host;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-port")
    private Integer port;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-user")
    private String user;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-password")
    private String password;
    @Inject(optional=true)
    @Named(value="jclouds.proxy-type")
    private Proxy.Type type = Proxy.Type.HTTP;

    @Override
    public Optional<HostAndPort> getProxy() {
        if (this.host == null) {
            return Optional.absent();
        }
        Integer port = this.port;
        if (port == null) {
            switch (this.type) {
                case HTTP: {
                    port = 80;
                    break;
                }
                case SOCKS: {
                    port = 1080;
                    break;
                }
                default: {
                    throw new IllegalArgumentException((Object)((Object)this.type) + " not supported");
                }
            }
        }
        return Optional.of((Object)HostAndPort.fromParts((String)this.host, (int)port));
    }

    @Override
    public Optional<Credentials> getCredentials() {
        if (this.user == null) {
            return Optional.absent();
        }
        return Optional.of((Object)new Credentials(this.user, GuiceProxyConfig.checkNotEmpty(this.password, "set property %s for user %s", "jclouds.proxy-password", this.user)));
    }

    private static String checkNotEmpty(String nullableString, String message, Object ... args) {
        Preconditions.checkArgument((Strings.emptyToNull((String)nullableString) != null ? 1 : 0) != 0, (String)message, (Object[])args);
        return nullableString;
    }

    @Override
    public Proxy.Type getType() {
        return this.type;
    }

    @Override
    public boolean useSystem() {
        return this.systemProxies;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("systemProxies", (Object)(this.systemProxies ? "true" : null)).add("proxy", this.getProxy().orNull()).add("user", (Object)this.user).add("type", (Object)(this.host != null ? this.type : null)).toString();
    }
}

