/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jclouds.util.Closeables2;

@Beta
public class ByteStreams2 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashCode hashAndClose(InputStream input, HashFunction hashFunction) throws IOException {
        Preconditions.checkNotNull((Object)input, (Object)"input");
        Preconditions.checkNotNull((Object)hashFunction, (Object)"hashFunction");
        try {
            HashingInputStream his = new HashingInputStream(hashFunction, input);
            ByteStreams.copy((InputStream)his, (OutputStream)ByteStreams.nullOutputStream());
            HashCode hashCode = his.hash();
            return hashCode;
        }
        finally {
            Closeables2.closeQuietly(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArrayAndClose(InputStream input) throws IOException {
        Preconditions.checkNotNull((Object)input, (Object)"input");
        try {
            byte[] byArray = ByteStreams.toByteArray((InputStream)input);
            return byArray;
        }
        finally {
            Closeables2.closeQuietly(input);
        }
    }
}

