/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.crypto;

import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSource;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import org.jclouds.crypto.ASN1Codec;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Closeables2;

@Beta
public class Pems {
    public static final String PRIVATE_PKCS1_MARKER = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String PRIVATE_PKCS8_MARKER = "-----BEGIN PRIVATE KEY-----";
    public static final String CERTIFICATE_X509_MARKER = "-----BEGIN CERTIFICATE-----";
    public static final String PUBLIC_X509_MARKER = "-----BEGIN PUBLIC KEY-----";
    public static final String PUBLIC_PKCS1_MARKER = "-----BEGIN RSA PUBLIC KEY-----";
    public static final String PROC_TYPE_ENCRYPTED = "Proc-Type: 4,ENCRYPTED";

    public static <T> T fromPem(ByteSource supplier, PemProcessor<T> processor) throws IOException {
        try {
            return (T)supplier.read(processor);
        }
        catch (RuntimeException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), IOException.class);
            Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
            throw e;
        }
    }

    public static KeySpec privateKeySpec(ByteSource supplier) throws IOException {
        return (KeySpec)Pems.fromPem(supplier, new PemProcessor(ImmutableMap.of((Object)PRIVATE_PKCS1_MARKER, (Object)DecodeRSAPrivateCrtKeySpec.INSTANCE, (Object)PRIVATE_PKCS8_MARKER, (Object)new PemProcessor.ResultParser<KeySpec>(){

            @Override
            public KeySpec parseResult(byte[] bytes) throws IOException {
                return new PKCS8EncodedKeySpec(bytes);
            }
        })));
    }

    public static KeySpec privateKeySpec(String pem) {
        try {
            return Pems.privateKeySpec(ByteSource.wrap((byte[])pem.getBytes(Charsets.UTF_8)));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static KeySpec publicKeySpec(ByteSource supplier) throws IOException {
        return (KeySpec)Pems.fromPem(supplier, new PemProcessor(ImmutableMap.of((Object)PUBLIC_PKCS1_MARKER, (Object)DecodeRSAPublicKeySpec.INSTANCE, (Object)PUBLIC_X509_MARKER, (Object)new PemProcessor.ResultParser<KeySpec>(){

            @Override
            public X509EncodedKeySpec parseResult(byte[] bytes) throws IOException {
                return new X509EncodedKeySpec(bytes);
            }
        })));
    }

    public static KeySpec publicKeySpec(String pem) throws IOException {
        return Pems.publicKeySpec(ByteSource.wrap((byte[])pem.getBytes(Charsets.UTF_8)));
    }

    public static X509Certificate x509Certificate(ByteSource supplier, @Nullable CertificateFactory certFactory) throws IOException, CertificateException {
        final CertificateFactory certs = certFactory != null ? certFactory : CertificateFactory.getInstance("X.509");
        try {
            return (X509Certificate)Pems.fromPem(supplier, new PemProcessor(ImmutableMap.of((Object)CERTIFICATE_X509_MARKER, (Object)new PemProcessor.ResultParser<X509Certificate>(){

                @Override
                public X509Certificate parseResult(byte[] bytes) throws IOException {
                    try {
                        return (X509Certificate)certs.generateCertificate(new ByteArrayInputStream(bytes));
                    }
                    catch (CertificateException e) {
                        throw new RuntimeException(e);
                    }
                }
            })));
        }
        catch (RuntimeException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), CertificateException.class);
            throw e;
        }
    }

    public static X509Certificate x509Certificate(String pem) throws IOException, CertificateException {
        return Pems.x509Certificate(ByteSource.wrap((byte[])pem.getBytes(Charsets.UTF_8)), null);
    }

    public static String pem(X509Certificate cert) throws CertificateEncodingException {
        String marker = CERTIFICATE_X509_MARKER;
        return Pems.pem(cert.getEncoded(), marker);
    }

    public static String pem(PublicKey key) {
        String marker = key instanceof RSAPublicKey ? PUBLIC_PKCS1_MARKER : PUBLIC_X509_MARKER;
        return Pems.pem(key.getEncoded(), marker);
    }

    public static String pem(PrivateKey key) {
        String marker = key instanceof RSAPrivateCrtKey ? PRIVATE_PKCS1_MARKER : PRIVATE_PKCS8_MARKER;
        return Pems.pem(key instanceof RSAPrivateCrtKey ? ASN1Codec.encode((RSAPrivateCrtKey)RSAPrivateCrtKey.class.cast(key)) : key.getEncoded(), marker);
    }

    private static String pem(byte[] encoded, String marker) {
        String ls = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append(marker).append(ls);
        builder.append(Joiner.on((String)ls).join(Splitter.fixedLength((int)64).split((CharSequence)BaseEncoding.base64().encode(encoded)))).append(ls);
        builder.append(marker.replace("BEGIN", "END")).append(ls);
        return builder.toString();
    }

    private static class PemProcessor<T>
    implements ByteProcessor<T> {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();
        private final Map<String, ResultParser<T>> parsers;

        private PemProcessor(Map<String, ResultParser<T>> parsers) {
            this.parsers = (Map)Preconditions.checkNotNull(parsers, (Object)"parsers");
        }

        public boolean processBytes(byte[] buf, int off, int len) {
            this.out.write(buf, off, len);
            return true;
        }

        public T getResult() {
            Pem pem = PemReader.INSTANCE.apply(new String(this.out.toByteArray(), Charsets.US_ASCII));
            String beginMarker = "-----BEGIN " + pem.type + "-----";
            Preconditions.checkState((boolean)this.parsers.containsKey(beginMarker), (String)"Invalid PEM: no parsers for marker %s in %s", (Object)beginMarker, this.parsers.keySet());
            try {
                return this.parsers.get(beginMarker).parseResult(pem.content);
            }
            catch (IOException e) {
                throw new IllegalStateException("Invalid PEM : " + String.valueOf(pem), e);
            }
        }

        private static interface ResultParser<T> {
            public T parseResult(byte[] var1) throws IOException;
        }
    }

    private static enum DecodeRSAPrivateCrtKeySpec implements PemProcessor.ResultParser<KeySpec>
    {
        INSTANCE;


        @Override
        public KeySpec parseResult(byte[] bytes) throws IOException {
            return ASN1Codec.decodeRSAPrivateKey(bytes);
        }
    }

    private static enum DecodeRSAPublicKeySpec implements PemProcessor.ResultParser<KeySpec>
    {
        INSTANCE;


        @Override
        public KeySpec parseResult(byte[] bytes) throws IOException {
            return ASN1Codec.decodeRSAPublicKey(bytes);
        }
    }

    private static final class Pem {
        private final String type;
        private final byte[] content;

        private Pem(String type, byte[] content) {
            this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.content = (byte[])Preconditions.checkNotNull((Object)content, (Object)"content");
        }

        public String toString() {
            return this.type + " " + new String(this.content, StandardCharsets.UTF_8);
        }
    }

    private static enum PemReader implements Function<CharSequence, Pem>
    {
        INSTANCE;

        private static final String BEGIN = "-----BEGIN ";
        private static final String END = "-----END ";

        public Pem apply(CharSequence chars) {
            Pem pem;
            Preconditions.checkNotNull((Object)chars, (Object)"chars");
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new StringReader(chars.toString()));
                Optional<String> begin = PemReader.skipUntilBegin(reader);
                Preconditions.checkArgument((boolean)begin.isPresent(), (String)"chars %s doesn't contain % line", (Object)chars, (Object)BEGIN);
                String line = ((String)begin.get()).substring(BEGIN.length());
                String type = line.substring(0, line.indexOf(45));
                StringBuilder encoded = new StringBuilder();
                boolean reachedEnd = false;
                while ((line = reader.readLine()) != null) {
                    if (line.indexOf(58) >= 0) continue;
                    if (line.indexOf(END + type) != -1) {
                        reachedEnd = true;
                        break;
                    }
                    encoded.append(line.trim());
                }
                Preconditions.checkArgument((boolean)reachedEnd, (String)"chars %s doesn't contain % line", (Object)chars, (Object)END);
                pem = new Pem(type, BaseEncoding.base64().decode((CharSequence)encoded.toString()));
            }
            catch (IOException e) {
                try {
                    throw new IllegalStateException(String.format("io exception reading %s", chars), e);
                }
                catch (Throwable throwable) {
                    Closeables2.closeQuietly(reader);
                    throw throwable;
                }
            }
            Closeables2.closeQuietly(reader);
            return pem;
        }

        private static Optional<String> skipUntilBegin(BufferedReader reader) throws IOException {
            String line = reader.readLine();
            while (line != null && !line.startsWith(BEGIN)) {
                line = reader.readLine();
            }
            return Optional.fromNullable((Object)line);
        }
    }
}

