/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.date.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtils {
    private static final String TZ_REGEX = "([+-][0-9][0-9](:?[0-9][0-9])?|Z)";
    private static final Pattern MILLIS_PATTERN = Pattern.compile("(.*\\.[0-9][0-9][0-9])[0-9]*([+-][0-9][0-9](:?[0-9][0-9])?|Z)?");
    private static final Pattern TZ_PATTERN = Pattern.compile("(.*)([+-][0-9][0-9](:?[0-9][0-9])?|Z)$");
    private static final Pattern SECOND_PATTERN = Pattern.compile(".*[0-2][0-9]:00");

    public static String trimToMillis(String toParse) {
        Matcher matcher = MILLIS_PATTERN.matcher((CharSequence)toParse);
        if (matcher.find()) {
            toParse = matcher.group(1);
            if (matcher.group(2) != null) {
                toParse = (String)toParse + matcher.group(2);
            }
        }
        return toParse;
    }

    public static String trimTZ(String toParse) {
        Matcher matcher = TZ_PATTERN.matcher(toParse);
        if (matcher.find()) {
            toParse = matcher.group(1);
        }
        if (toParse.length() == 25 && SECOND_PATTERN.matcher(toParse).matches()) {
            toParse = toParse.substring(0, toParse.length() - 6);
        }
        return toParse;
    }

    public static String findTZ(String toParse) {
        Matcher matcher = TZ_PATTERN.matcher(toParse);
        if (matcher.find()) {
            Object tz = matcher.group(2).replace(":", "");
            if (((String)tz).length() == 2) {
                tz = (String)tz + "00";
            }
            if (((String)tz).equals("Z")) {
                return "+0000";
            }
            return tz;
        }
        return "+0000";
    }
}

