/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.util.Date;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.payloads.BaseImmutableContentMetadata;
import org.jclouds.javax.annotation.Nullable;

public class ContentMetadataBuilder {
    protected String cacheControl;
    protected String contentType = "application/unknown";
    protected Long contentLength;
    protected HashCode contentMD5;
    protected String contentDisposition;
    protected String contentLanguage;
    protected String contentEncoding;
    protected Date expires;

    public static ContentMetadataBuilder create() {
        return new ContentMetadataBuilder();
    }

    public ContentMetadataBuilder cacheControl(@Nullable String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public ContentMetadataBuilder contentLength(@Nullable Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    @Deprecated
    public ContentMetadataBuilder contentMD5(@Nullable byte[] contentMD5) {
        return this.contentMD5(contentMD5 == null ? null : HashCode.fromBytes((byte[])contentMD5));
    }

    public ContentMetadataBuilder contentMD5(@Nullable HashCode contentMD5) {
        if (contentMD5 != null) {
            Preconditions.checkArgument((contentMD5.bits() == 128 ? 1 : 0) != 0, (String)"MD5 hash must have 128 bits, was: %s", (int)contentMD5.bits());
        }
        this.contentMD5 = contentMD5;
        return this;
    }

    public ContentMetadataBuilder contentType(@Nullable String contentType) {
        this.contentType = contentType;
        return this;
    }

    public ContentMetadataBuilder contentDisposition(@Nullable String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public ContentMetadataBuilder contentLanguage(@Nullable String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public ContentMetadataBuilder contentEncoding(@Nullable String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public ContentMetadataBuilder expires(@Nullable Date expires) {
        this.expires = expires;
        return this;
    }

    public ContentMetadata build() {
        return new BaseImmutableContentMetadata(this.cacheControl, this.contentType, this.contentLength, this.contentMD5 == null ? null : this.contentMD5.asBytes(), this.contentDisposition, this.contentLanguage, this.contentEncoding, this.expires);
    }

    public static ContentMetadataBuilder fromContentMetadata(ContentMetadata in) {
        return new ContentMetadataBuilder().cacheControl(in.getCacheControl()).contentType(in.getContentType()).contentLength(in.getContentLength()).contentMD5(in.getContentMD5()).contentDisposition(in.getContentDisposition()).contentLanguage(in.getContentLanguage()).contentEncoding(in.getContentEncoding()).expires(in.getExpires());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.contentDisposition, this.contentEncoding, this.contentLanguage, this.contentLength, this.contentMD5, this.contentType, this.expires});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentMetadataBuilder other = (ContentMetadataBuilder)obj;
        return Objects.equal((Object)this.cacheControl, (Object)other.cacheControl) && Objects.equal((Object)this.contentDisposition, (Object)other.contentDisposition) && Objects.equal((Object)this.contentEncoding, (Object)other.contentEncoding) && Objects.equal((Object)this.contentLanguage, (Object)other.contentLanguage) && Objects.equal((Object)this.contentLength, (Object)other.contentLength) && Objects.equal((Object)this.contentMD5, (Object)other.contentMD5) && Objects.equal((Object)this.contentType, (Object)other.contentType) && Objects.equal((Object)this.expires, (Object)other.expires);
    }

    public String toString() {
        return "[cacheControl=" + this.cacheControl + ", contentDisposition=" + this.contentDisposition + ", contentEncoding=" + this.contentEncoding + ", contentLanguage=" + this.contentLanguage + ", contentLength=" + this.contentLength + ", contentMD5=" + String.valueOf(this.contentMD5) + ", contentType=" + this.contentType + ", expires=" + String.valueOf(this.expires) + "]";
    }
}

