/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteSource;
import java.io.File;
import java.io.InputStream;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.io.payloads.FilePayload;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.io.payloads.UrlEncodedFormPayload;

public class Payloads {
    private Payloads() {
    }

    public static Payload newPayload(Object data) {
        Preconditions.checkNotNull((Object)data, (Object)"data");
        if (data instanceof Payload) {
            return (Payload)data;
        }
        if (data instanceof InputStream) {
            return Payloads.newInputStreamPayload((InputStream)data);
        }
        if (data instanceof byte[]) {
            return Payloads.newByteArrayPayload((byte[])data);
        }
        if (data instanceof ByteSource) {
            return Payloads.newByteSourcePayload((ByteSource)data);
        }
        if (data instanceof String) {
            return Payloads.newStringPayload((String)data);
        }
        if (data instanceof File) {
            return Payloads.newFilePayload((File)data);
        }
        throw new UnsupportedOperationException("unsupported payload type: " + String.valueOf(data.getClass()));
    }

    public static InputStreamPayload newInputStreamPayload(InputStream data) {
        return new InputStreamPayload((InputStream)Preconditions.checkNotNull((Object)data, (Object)"data"));
    }

    public static ByteArrayPayload newByteArrayPayload(byte[] data) {
        return new ByteArrayPayload((byte[])Preconditions.checkNotNull((Object)data, (Object)"data"));
    }

    public static ByteSourcePayload newByteSourcePayload(ByteSource data) {
        return new ByteSourcePayload((ByteSource)Preconditions.checkNotNull((Object)data, (Object)"data"));
    }

    public static StringPayload newStringPayload(String data) {
        return new StringPayload((String)Preconditions.checkNotNull((Object)data, (Object)"data"));
    }

    public static FilePayload newFilePayload(File data) {
        return new FilePayload((File)Preconditions.checkNotNull((Object)data, (Object)"data"));
    }

    public static UrlEncodedFormPayload newUrlEncodedFormPayload(Multimap<String, String> formParams) {
        return new UrlEncodedFormPayload(formParams);
    }
}

