/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.DelegatingPayload;
import org.jclouds.io.payloads.FilePayload;
import org.jclouds.javax.annotation.Nullable;

public class Part
extends DelegatingPayload {
    final String name;
    final Multimap<String, String> headers;

    private Part(String name, PartMap map, Payload delegate) {
        super(delegate);
        this.name = name;
        this.headers = ((PartMap)((Object)Preconditions.checkNotNull((Object)((Object)map), (Object)"headers"))).build();
    }

    public static Part create(String name, String value) {
        return new Part(name, PartMap.create(name), Payloads.newStringPayload(value));
    }

    public static Part create(String name, Payload delegate, PartOptions options) {
        return new Part(name, PartMap.create(name, delegate, options), delegate);
    }

    public Multimap<String, String> getHeaders() {
        return this.headers;
    }

    public String getName() {
        return this.name;
    }

    private static class PartMap
    extends ImmutableMultimap.Builder<String, String> {
        private PartMap() {
        }

        static PartMap create(String name) {
            PartMap map = new PartMap();
            map.put("Content-Disposition", String.format("form-data; name=\"%s\"", Preconditions.checkNotNull((Object)name, (Object)"name")));
            return map;
        }

        static PartMap create(String name, String filename) {
            PartMap map = new PartMap();
            map.put("Content-Disposition", String.format("form-data; name=\"%s\"; filename=\"%s\"", Preconditions.checkNotNull((Object)name, (Object)"name"), Preconditions.checkNotNull((Object)filename, (Object)"filename")));
            return map;
        }

        PartMap contentType(@Nullable String type) {
            if (type != null) {
                this.put("Content-Type", (String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            }
            return this;
        }

        public static PartMap create(String name, Payload delegate, PartOptions options) {
            PartMap returnVal;
            String filename;
            String string = filename = options != null ? options.getFilename() : null;
            if (delegate instanceof FilePayload) {
                filename = ((File)((FilePayload)FilePayload.class.cast(delegate)).getRawContent()).getName();
            }
            PartMap partMap = returnVal = filename != null ? PartMap.create(name, filename) : PartMap.create(name);
            if (options != null) {
                returnVal.contentType(options.getContentType());
            }
            return returnVal;
        }
    }

    public static class PartOptions {
        private String contentType;
        private String filename;

        public PartOptions contentType(String contentType) {
            this.contentType = (String)Preconditions.checkNotNull((Object)contentType, (Object)"contentType");
            return this;
        }

        public PartOptions filename(String filename) {
            this.filename = (String)Preconditions.checkNotNull((Object)filename, (Object)"filename");
            return this;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getFilename() {
            return this.filename;
        }

        public static class Builder {
            public static PartOptions contentType(String contentType) {
                return new PartOptions().contentType(contentType);
            }

            public static PartOptions filename(String filename) {
                return new PartOptions().filename(filename);
            }
        }
    }
}

