/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.TypeToken;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.annotations.SerializedName;
import jakarta.inject.Named;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jclouds.json.SerializedNames;
import org.jclouds.reflect.Reflection2;

public class NamingStrategies {

    public static final class AnnotationConstructorNamingStrategy
    extends AnnotationBasedNamingStrategy {
        private final Predicate<Invokable<?, ?>> hasMarker;
        private final Collection<? extends Class<? extends Annotation>> markers;

        public AnnotationConstructorNamingStrategy(Collection<? extends Class<? extends Annotation>> markers, Iterable<? extends NameExtractor<?>> extractors) {
            super(extractors);
            this.markers = (Collection)Preconditions.checkNotNull(markers, (Object)"you must supply at least one annotation to mark deserialization constructors");
            this.hasMarker = AnnotationConstructorNamingStrategy.hasAnnotationIn(markers);
        }

        private static Predicate<Invokable<?, ?>> hasAnnotationIn(final Collection<? extends Class<? extends Annotation>> markers) {
            return new Predicate<Invokable<?, ?>>(){

                public boolean apply(Invokable<?, ?> input) {
                    return FluentIterable.from(Arrays.asList(input.getAnnotations())).transform((Function)new Function<Annotation, Class<? extends Annotation>>(){

                        public Class<? extends Annotation> apply(Annotation input) {
                            return input.annotationType();
                        }
                    }).anyMatch(Predicates.in((Collection)markers));
                }
            };
        }

        @VisibleForTesting
        <T> Invokable<T, T> getDeserializer(TypeToken<T> token) {
            return (Invokable)Iterables.tryFind(Reflection2.constructors(token), this.hasMarker).orNull();
        }

        @VisibleForTesting
        <T> String translateName(Invokable<T, T> c, int index) {
            String name;
            block3: {
                block2: {
                    Object[] names;
                    name = null;
                    if ((!this.markers.contains(ConstructorProperties.class) || c.getAnnotation(ConstructorProperties.class) == null) && (!this.markers.contains(SerializedNames.class) || c.getAnnotation(SerializedNames.class) == null)) break block2;
                    Object[] objectArray = names = c.getAnnotation(SerializedNames.class) != null ? ((SerializedNames)c.getAnnotation(SerializedNames.class)).value() : ((ConstructorProperties)c.getAnnotation(ConstructorProperties.class)).value();
                    if (names.length != c.getParameters().size()) {
                        String message = "Incorrect count of names on annotation of %s. Class: [%s]. Annotation config: [%s]. Parameters; [%s]";
                        String types = Joiner.on((String)",").join(Iterables.transform((Iterable)c.getParameters(), (Function)new Function<Parameter, String>(){

                            public String apply(Parameter input) {
                                return input.getClass().getName();
                            }
                        }));
                        throw new IllegalArgumentException(String.format(message, c, c.getDeclaringClass().getName(), Joiner.on((String)",").join(names), types));
                    }
                    if (names == null || names.length <= index) break block3;
                    name = names[index];
                    break block3;
                }
                for (Annotation annotation : ((Parameter)c.getParameters().get(index)).getAnnotations()) {
                    if (!this.annotationToNameExtractor.containsKey(annotation.annotationType())) continue;
                    name = ((NameExtractor)this.annotationToNameExtractor.get(annotation.annotationType())).apply(annotation);
                    break;
                }
            }
            return name;
        }
    }

    public static class AnnotationOrNameFieldNamingStrategy
    extends AnnotationFieldNamingStrategy
    implements FieldNamingStrategy {
        public AnnotationOrNameFieldNamingStrategy(Iterable<? extends NameExtractor<?>> extractors) {
            super(extractors);
        }

        @Override
        public String translateName(Field f) {
            String result = super.translateName(f);
            return result == null ? f.getName() : result;
        }
    }

    public static class AnnotationFieldNamingStrategy
    extends AnnotationBasedNamingStrategy
    implements FieldNamingStrategy {
        public AnnotationFieldNamingStrategy(Iterable<? extends NameExtractor<?>> extractors) {
            super(extractors);
            Preconditions.checkArgument((boolean)extractors.iterator().hasNext(), (Object)("you must supply at least one name extractor, for example: " + ExtractSerializedName.class.getSimpleName()));
        }

        public String translateName(Field f) {
            if (Modifier.isAbstract(f.getDeclaringClass().getSuperclass().getModifiers())) {
                for (Invokable invokable : Reflection2.constructors(TypeToken.of(f.getDeclaringClass().getSuperclass()))) {
                    SerializedNames names = (SerializedNames)invokable.getAnnotation(SerializedNames.class);
                    if (names == null || !invokable.isStatic()) continue;
                    List<Field> declaredFields = Arrays.asList(f.getDeclaringClass().getDeclaredFields());
                    Iterable fields = Iterables.filter(declaredFields, (Predicate)new Predicate<Field>(){

                        public boolean apply(Field input) {
                            return !input.isSynthetic();
                        }
                    });
                    int numFields = Iterables.size((Iterable)fields);
                    if (numFields != names.value().length) {
                        String message = "Incorrect number of names on %s. Class [%s]. Annotation config: [%s]. Fields in object; [%s]";
                        String types = Joiner.on((String)",").join(Iterables.transform((Iterable)fields, (Function)new Function<Field, String>(){

                            public String apply(Field input) {
                                return input.getType().getName();
                            }
                        }));
                        throw new IllegalStateException(String.format(message, names, f.getDeclaringClass().getName(), Joiner.on((String)",").join((Object[])names.value()), types));
                    }
                    for (int i = 0; i < numFields; ++i) {
                        if (!((Field)Iterables.get((Iterable)fields, (int)i)).equals(f)) continue;
                        return names.value()[i];
                    }
                    throw new IllegalStateException("Inconsistent state. Ensure type is AutoValue on " + String.valueOf(invokable));
                }
            }
            for (Annotation annotation : f.getAnnotations()) {
                if (!this.annotationToNameExtractor.containsKey(annotation.annotationType())) continue;
                return ((NameExtractor)this.annotationToNameExtractor.get(annotation.annotationType())).apply(annotation);
            }
            return null;
        }
    }

    public static abstract class AnnotationBasedNamingStrategy {
        protected final Map<Class<? extends Annotation>, ? extends NameExtractor<?>> annotationToNameExtractor;
        protected final String forToString;

        public AnnotationBasedNamingStrategy(Iterable<? extends NameExtractor<?>> extractors) {
            Preconditions.checkNotNull(extractors, (Object)"means to extract names by annotations");
            this.annotationToNameExtractor = Maps.uniqueIndex(extractors, (Function)new Function<NameExtractor<?>, Class<? extends Annotation>>(){

                public Class<? extends Annotation> apply(NameExtractor<?> input) {
                    return input.annotationType();
                }
            });
            this.forToString = Joiner.on((String)",").join(Iterables.transform(extractors, (Function)new Function<NameExtractor<?>, String>(){

                public String apply(NameExtractor<?> input) {
                    return input.annotationType().getName();
                }
            }));
        }

        public String toString() {
            return "AnnotationBasedNamingStrategy requiring one of " + this.forToString;
        }
    }

    public static class ExtractNamed
    extends NameExtractor<Named> {
        public ExtractNamed() {
            super(Named.class);
        }

        @Override
        public String extractName(Named in) {
            return ((Named)Preconditions.checkNotNull((Object)in, (Object)"input annotation")).value();
        }
    }

    public static class ExtractSerializedName
    extends NameExtractor<SerializedName> {
        public ExtractSerializedName() {
            super(SerializedName.class);
        }

        @Override
        public String extractName(SerializedName in) {
            return ((SerializedName)Preconditions.checkNotNull((Object)in, (Object)"input annotation")).value();
        }
    }

    public static abstract class NameExtractor<A extends Annotation>
    implements Function<Annotation, String>,
    Supplier<Predicate<Annotation>> {
        protected final Class<A> annotationType;
        protected final Predicate<Annotation> predicate;

        protected NameExtractor(final Class<A> annotationType) {
            this.annotationType = (Class)Preconditions.checkNotNull(annotationType, (Object)"annotationType");
            this.predicate = new Predicate<Annotation>(){

                public boolean apply(Annotation input) {
                    return input.getClass().equals(annotationType);
                }
            };
        }

        public Class<Annotation> annotationType() {
            return this.annotationType;
        }

        public String apply(Annotation in) {
            return this.extractName((Annotation)this.annotationType.cast(in));
        }

        protected abstract String extractName(A var1);

        public Predicate<Annotation> get() {
            return this.predicate;
        }

        public String toString() {
            return "nameExtractor(" + this.annotationType.getSimpleName() + ")";
        }

        public int hashCode() {
            return this.annotationType.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.annotationType.equals(((NameExtractor)NameExtractor.class.cast((Object)obj)).annotationType);
        }
    }
}

