/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.lifecycle;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListeningExecutorService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.lifecycle.LifeCycle;
import org.jclouds.logging.Logger;

public abstract class BaseLifeCycle
implements Runnable,
LifeCycle {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final ListeningExecutorService userExecutor;
    protected final List<LifeCycle> dependencies;
    protected final Object statusLock;
    protected volatile LifeCycle.Status status;
    protected AtomicReference<Exception> exception = Atomics.newReference();

    public BaseLifeCycle(ListeningExecutorService userExecutor, LifeCycle ... dependencies) {
        this.userExecutor = userExecutor;
        this.dependencies = Lists.newArrayList();
        this.dependencies.addAll(Arrays.asList(dependencies));
        this.statusLock = new Object();
        this.status = LifeCycle.Status.INACTIVE;
    }

    public void addDependency(LifeCycle lifeCycle) {
        this.dependencies.add(lifeCycle);
    }

    @Override
    public LifeCycle.Status getStatus() {
        return this.status;
    }

    @Override
    public void run() {
        try {
            while (this.shouldDoWork()) {
                this.doWork();
            }
        }
        catch (Exception e) {
            this.logger.error(e, "Exception doing work", new Object[0]);
            this.exception.set(e);
        }
        this.status = LifeCycle.Status.SHUTTING_DOWN;
        this.doShutdown();
        this.status = LifeCycle.Status.SHUT_DOWN;
        this.logger.info("Shutdown %s", this);
    }

    protected abstract void doWork() throws Exception;

    protected abstract void doShutdown();

    protected boolean shouldDoWork() {
        try {
            this.exceptionIfDependenciesNotActive();
        }
        catch (IllegalStateException e) {
            return false;
        }
        return this.status.equals((Object)LifeCycle.Status.ACTIVE) && this.exception.get() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PostConstruct
    public void start() {
        this.logger.info("Starting %s", this);
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status.compareTo(LifeCycle.Status.SHUTDOWN_REQUEST) >= 0) {
                this.doShutdown();
                this.status = LifeCycle.Status.SHUT_DOWN;
                this.statusLock.notifyAll();
                return;
            }
            if (this.status.compareTo(LifeCycle.Status.ACTIVE) == 0) {
                this.statusLock.notifyAll();
                return;
            }
            if (this.status.compareTo(LifeCycle.Status.INACTIVE) != 0) {
                throw new IllegalStateException("Illegal state: " + String.valueOf((Object)this.status));
            }
            this.exceptionIfDependenciesNotActive();
            this.status = LifeCycle.Status.ACTIVE;
        }
        this.userExecutor.execute((Runnable)this);
    }

    protected void exceptionIfDependenciesNotActive() {
        for (LifeCycle dependency : this.dependencies) {
            if (dependency.getStatus().compareTo(LifeCycle.Status.ACTIVE) == 0) continue;
            throw new IllegalStateException(String.format("Illegal state: %s for component: %s", new Object[]{dependency.getStatus(), dependency}));
        }
    }

    protected Exception getExceptionFromDependenciesOrNull() {
        for (LifeCycle dependency : this.dependencies) {
            if (dependency.getException() == null) continue;
            return dependency.getException();
        }
        return null;
    }

    @Override
    public Exception getException() {
        return this.exception.get();
    }

    protected void awaitShutdown(long timeout) throws InterruptedException {
        this.awaitStatus(LifeCycle.Status.SHUT_DOWN, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awaitStatus(LifeCycle.Status intended, long timeout) throws InterruptedException {
        Object object = this.statusLock;
        synchronized (object) {
            long deadline = System.currentTimeMillis() + timeout;
            long remaining = timeout;
            while (this.status != intended) {
                this.statusLock.wait(remaining);
                if (timeout <= 0L || (remaining = deadline - System.currentTimeMillis()) > 0L) continue;
            }
        }
    }

    @Override
    @PreDestroy
    public void shutdown() {
        this.shutdown(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(long waitMs) {
        Object object = this.statusLock;
        synchronized (object) {
            if (this.status.compareTo(LifeCycle.Status.ACTIVE) > 0) {
                return;
            }
            this.status = LifeCycle.Status.SHUTDOWN_REQUEST;
            try {
                this.awaitShutdown(waitMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void exceptionIfNotActive() {
        if (!this.status.equals((Object)LifeCycle.Status.ACTIVE)) {
            throw new IllegalStateException(String.format("not active: %s", this));
        }
    }
}

