/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.implicit;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.location.functions.ToIdAndScope;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;

@Singleton
public class FirstNetwork
implements ImplicitLocationSupplier {
    private final Supplier<Set<? extends Location>> locationsSupplier;

    @Inject
    FirstNetwork(@Memoized Supplier<Set<? extends Location>> locationsSupplier) {
        this.locationsSupplier = (Supplier)Preconditions.checkNotNull(locationsSupplier, (Object)"locationsSupplierSupplier");
    }

    public Location get() {
        Set locations = (Set)this.locationsSupplier.get();
        try {
            return (Location)Iterables.find((Iterable)locations, LocationPredicates.isNetwork());
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("none of the locations are scope NETWORK: " + String.valueOf(Iterables.transform((Iterable)locations, (Function)ToIdAndScope.INSTANCE)));
        }
    }
}

