/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.Chars;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class PasswordGenerator {
    private static final Random RANDOM = new SecureRandom();
    private final Config lower = new Config("abcdefghijklmnopqrstuvwxyz").min(3).max(5);
    private final Config upper = new Config("ABCDEFGHIJKLMNOPQRSTUVWXYZ").min(3).max(5);
    private final Config numbers = new Config("1234567890").min(3).max(5);
    private final Config symbols = new Config("~@#%*()-_=+:,.?").min(3).max(5);

    public Config lower() {
        return this.lower;
    }

    public Config upper() {
        return this.upper;
    }

    public Config numbers() {
        return this.numbers;
    }

    public Config symbols() {
        return this.symbols;
    }

    public String generate() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.lower.fragment());
        sb.append(this.upper.fragment());
        sb.append(this.numbers.fragment());
        sb.append(this.symbols.fragment());
        return PasswordGenerator.shuffleAndJoin(sb.toString().toCharArray());
    }

    private static String shuffleAndJoin(char[] chars) {
        List result = Chars.asList((char[])chars);
        Collections.shuffle(result);
        return Joiner.on((String)"").join((Iterable)result);
    }

    public class Config {
        private final String characters;
        private char[] exclusions;
        private int minLength;
        private int maxLength;

        private Config(String characters) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)characters) ? 1 : 0) != 0, (Object)"charactets must be a non-empty string");
            this.characters = characters;
        }

        public Config exclude(char[] exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        public Config min(int num) {
            this.minLength = num;
            return this;
        }

        public Config max(int num) {
            this.maxLength = num;
            return this;
        }

        public Config count(int num) {
            this.min(num);
            this.max(num);
            return this;
        }

        private String fragment() {
            int length = this.minLength + RANDOM.nextInt(this.maxLength - this.minLength + 1);
            return new Generator(this.characters, length, this.exclusions).generate();
        }

        public Config lower() {
            return PasswordGenerator.this.lower();
        }

        public Config upper() {
            return PasswordGenerator.this.upper();
        }

        public Config numbers() {
            return PasswordGenerator.this.numbers();
        }

        public Config symbols() {
            return PasswordGenerator.this.symbols();
        }

        public String generate() {
            return PasswordGenerator.this.generate();
        }
    }

    private static class Generator {
        private final char[] characters;
        private final int count;

        private Generator(String characters, int count, char[] exclusions) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)characters) ? 1 : 0) != 0, (Object)"charactets must be a non-empty string");
            this.count = count;
            this.characters = exclusions == null || exclusions.length == 0 ? characters.toCharArray() : characters.replaceAll("[" + new String(exclusions) + "]", "").toCharArray();
        }

        public String generate() {
            char[] selected = new char[this.count];
            for (int i = 0; i < this.count; ++i) {
                selected[i] = this.characters[RANDOM.nextInt(this.characters.length)];
            }
            return PasswordGenerator.shuffleAndJoin(selected);
        }
    }
}

