/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.loadbalancer;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import com.google.common.reflect.TypeToken;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.BaseViewLiveTest;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.loadbalancer.LoadBalancerServiceContext;
import org.jclouds.loadbalancer.domain.LoadBalancerMetadata;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.reflect.Reflection2;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public abstract class BaseLoadBalancerServiceLiveTest
extends BaseViewLiveTest<LoadBalancerServiceContext> {
    protected TemplateBuilderSpec template;
    protected LoginCredentials loginCredentials = LoginCredentials.builder().user("root").build();
    protected String group;
    protected Predicate<HostAndPort> socketTester;
    protected Set<? extends NodeMetadata> nodes;
    protected LoadBalancerMetadata loadbalancer;
    protected String computeProvider;
    protected String computeIdentity;
    protected String computeCredential;
    protected String computeEndpoint;
    protected String computeApiversion;
    protected String computeBuildversion;
    protected ComputeServiceContext computeContext;

    protected Properties setupComputeProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.trust-all-certs", "true");
        overrides.setProperty("jclouds.relax-hostname", "true");
        this.computeProvider = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.provider");
        this.computeIdentity = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.identity");
        this.computeCredential = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.credential");
        this.computeEndpoint = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.endpoint");
        this.computeApiversion = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.api-version");
        this.computeBuildversion = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.build-version");
        String spec = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.template");
        if (spec != null) {
            this.template = TemplateBuilderSpec.parse((String)spec);
            if (this.template.getLoginUser() != null) {
                Iterable userPass = Splitter.on((char)':').split((CharSequence)this.template.getLoginUser());
                LoginCredentials.Builder loginCredentialsBuilder = LoginCredentials.builder();
                loginCredentialsBuilder.user((String)Iterables.get((Iterable)userPass, (int)0));
                if (Iterables.size((Iterable)userPass) == 2) {
                    loginCredentialsBuilder.password((String)Iterables.get((Iterable)userPass, (int)1));
                }
                if (this.template.getAuthenticateSudo() != null) {
                    loginCredentialsBuilder.authenticateSudo(this.template.getAuthenticateSudo().booleanValue());
                }
                this.loginCredentials = loginCredentialsBuilder.build();
            }
        }
        return overrides;
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        if (this.group == null) {
            this.group = (String)Preconditions.checkNotNull((Object)this.provider, (Object)"provider");
        }
        if (this.group.indexOf(45) == -1) {
            this.group = new StringBuilder(this.group).insert(1, "-").toString();
        }
        this.initializeComputeContext();
        this.buildSocketTester();
    }

    protected void initializeComputeContext() {
        if (this.computeContext != null) {
            this.computeContext.close();
        }
        Properties overrides = this.setupComputeProperties();
        ContextBuilder builder = ContextBuilder.newBuilder((String)this.computeProvider).credentials(this.computeIdentity, this.computeCredential).overrides(overrides).modules(this.setupModules());
        if (this.computeApiversion != null) {
            builder.apiVersion(this.computeApiversion);
        }
        if (this.computeBuildversion != null) {
            builder.buildVersion(this.computeBuildversion);
        }
        this.computeContext = (ComputeServiceContext)builder.buildView(ComputeServiceContext.class);
    }

    protected void buildSocketTester() {
        SocketOpen socketOpen = (SocketOpen)Guice.createInjector((Module[])new Module[]{this.getSshModule()}).getInstance(SocketOpen.class);
        this.socketTester = Predicates2.retry((Predicate)socketOpen, (long)60L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    protected abstract Module getSshModule();

    @BeforeClass(groups={"integration", "live"}, dependsOnMethods={"setupContext"})
    public void createNodes() throws RunNodesException {
        try {
            TemplateBuilder builder = this.computeContext.getComputeService().templateBuilder();
            if (this.template != null) {
                builder.from(this.template);
            }
            this.nodes = this.computeContext.getComputeService().createNodesInGroup(this.group, 2, builder.build());
        }
        catch (RunNodesException e) {
            this.nodes = e.getSuccessfulNodes();
            throw e;
        }
    }

    @Test(enabled=true)
    public void testLoadBalanceNodesMatching() throws Exception {
        this.loadbalancer = ((LoadBalancerServiceContext)this.view).getLoadBalancerService().createLoadBalancerInLocation(null, this.group, "HTTP", 80, 80, this.nodes);
        Assert.assertNotNull((Object)this.loadbalancer);
        this.validateNodesInLoadBalancer();
    }

    protected abstract void validateNodesInLoadBalancer();

    @Test(enabled=true, dependsOnMethods={"testLoadBalanceNodesMatching"})
    public void testDestroyLoadBalancers() throws Exception {
        ((LoadBalancerServiceContext)this.view).getLoadBalancerService().destroyLoadBalancer(this.loadbalancer.getId());
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDownContext() {
        if (this.loadbalancer != null) {
            ((LoadBalancerServiceContext)this.view).getLoadBalancerService().destroyLoadBalancer(this.loadbalancer.getId());
        }
        if (this.nodes != null) {
            this.computeContext.getComputeService().destroyNodesMatching(NodePredicates.inGroup((String)this.group));
        }
        this.computeContext.close();
        super.tearDownContext();
    }

    protected TypeToken<LoadBalancerServiceContext> viewType() {
        return Reflection2.typeToken(LoadBalancerServiceContext.class);
    }
}

