/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain.chef;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.jclouds.scriptbuilder.domain.chef.RunList;

public class Role {
    private String name;
    private Optional<String> description;
    private Optional<String> jsonDefaultAttributes;
    private Optional<String> jsonOverrideAttributes;
    private RunList runlist;

    public static Builder builder() {
        return new Builder();
    }

    protected Role(String name, Optional<String> description, Optional<String> jsonDefaultAttributes, Optional<String> jsonOverrideAttributes, Optional<RunList> runlist) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name must be set");
        this.description = (Optional)Preconditions.checkNotNull(description, (Object)"description must be set");
        this.jsonDefaultAttributes = (Optional)Preconditions.checkNotNull(jsonDefaultAttributes, (Object)"jsonDefaultAttributes must be set");
        this.jsonOverrideAttributes = (Optional)Preconditions.checkNotNull(jsonOverrideAttributes, (Object)"jsonOverrideAttributes must be set");
        this.runlist = (RunList)((Optional)Preconditions.checkNotNull(runlist, (Object)"runlist must be set")).or((Object)RunList.builder().build());
    }

    public String toJsonString() {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"name\": \"").append(this.name).append("\",");
        json.append("\"description\":\"").append((String)this.description.or((Object)"")).append("\",");
        json.append("\"default_attributes\":").append((String)this.jsonDefaultAttributes.or((Object)"{}")).append(",");
        json.append("\"override_attributes\":").append((String)this.jsonOverrideAttributes.or((Object)"{}")).append(",");
        json.append("\"json_class\":\"Chef::Role\",");
        json.append("\"chef_type\":\"role\",");
        json.append("\"run_list\":" + this.runlist.toString());
        json.append("}");
        return json.toString();
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Optional<String> getJsonDefaultAttributes() {
        return this.jsonDefaultAttributes;
    }

    public Optional<String> getJsonOverrideAttributes() {
        return this.jsonOverrideAttributes;
    }

    public RunList getRunlist() {
        return this.runlist;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Role other = (Role)Role.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)other.name);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("description", this.description.orNull()).toString();
    }

    public static class Builder {
        private String name;
        private String description;
        private String jsonDefaultAttributes;
        private String jsonOverrideAttributes;
        private RunList runlist;

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name must be set");
            return this;
        }

        public Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description must be set");
            return this;
        }

        public Builder jsonDefaultAttributes(String jsonDefaultAttributes) {
            this.jsonDefaultAttributes = (String)Preconditions.checkNotNull((Object)jsonDefaultAttributes, (Object)"jsonDefaultAttributes must be set");
            return this;
        }

        public Builder jsonOverrideAttributes(String jsonOverrideAttributes) {
            this.jsonOverrideAttributes = (String)Preconditions.checkNotNull((Object)jsonOverrideAttributes, (Object)"jsonOverrideAttributes must be set");
            return this;
        }

        public Builder runlist(RunList runlist) {
            this.runlist = (RunList)Preconditions.checkNotNull((Object)runlist, (Object)"runlist must be set");
            return this;
        }

        public Role build() {
            return new Role(this.name, (Optional<String>)Optional.fromNullable((Object)this.description), (Optional<String>)Optional.fromNullable((Object)this.jsonDefaultAttributes), (Optional<String>)Optional.fromNullable((Object)this.jsonOverrideAttributes), (Optional<RunList>)Optional.fromNullable((Object)this.runlist));
        }
    }
}

