/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.chef;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.domain.chef.DataBag;
import org.jclouds.scriptbuilder.domain.chef.Role;
import org.jclouds.scriptbuilder.domain.chef.RunList;

public class ChefSolo
implements Statement {
    public static final String DEFAULT_SOLO_PATH = "/var/chef";
    private String fileCachePath;
    private String rolePath;
    private String databagPath;
    private List<String> cookbookPath;
    private Optional<String> cookbooksArchiveLocation;
    private Optional<String> jsonAttributes;
    private Optional<String> group;
    private Optional<Integer> interval;
    private Optional<String> logLevel;
    private Optional<String> logFile;
    private Optional<String> nodeName;
    private Optional<Integer> splay;
    private Optional<String> user;
    private Optional<List<Role>> roles;
    private Optional<List<DataBag>> databags;
    private RunList runlist;

    public static Builder builder() {
        return new Builder();
    }

    protected ChefSolo(Optional<String> fileCachePath, Optional<String> rolePath, Optional<String> databagPath, Optional<ImmutableList<String>> cookbookPath, Optional<String> cookbooksArchiveLocation, Optional<String> jsonAttributes, Optional<String> group, Optional<Integer> interval, Optional<String> logLevel, Optional<String> logFile, Optional<String> nodeName, Optional<Integer> splay, Optional<String> user, Optional<List<Role>> roles, Optional<List<DataBag>> databags, Optional<RunList> runlist) {
        this.fileCachePath = (String)((Optional)Preconditions.checkNotNull(fileCachePath, (Object)"fileCachePath must be set")).or((Object)DEFAULT_SOLO_PATH);
        this.rolePath = (String)((Optional)Preconditions.checkNotNull(rolePath, (Object)"rolePath must be set")).or((Object)(this.fileCachePath + "/roles"));
        this.databagPath = (String)((Optional)Preconditions.checkNotNull(databagPath, (Object)"databagPath must be set")).or((Object)(this.fileCachePath + "/data_bags"));
        this.cookbooksArchiveLocation = (Optional)Preconditions.checkNotNull(cookbooksArchiveLocation, (Object)"cookbooksArchiveLocation must be set");
        this.jsonAttributes = (Optional)Preconditions.checkNotNull(jsonAttributes, (Object)"jsonAttributes must be set");
        this.group = (Optional)Preconditions.checkNotNull(group, (Object)"group must be set");
        this.interval = (Optional)Preconditions.checkNotNull(interval, (Object)"interval must be set");
        this.logLevel = (Optional)Preconditions.checkNotNull(logLevel, (Object)"logLevel must be set");
        this.logFile = (Optional)Preconditions.checkNotNull(logFile, (Object)"logFile must be set");
        this.nodeName = (Optional)Preconditions.checkNotNull(nodeName, (Object)"nodeName must be set");
        this.splay = (Optional)Preconditions.checkNotNull(splay, (Object)"splay must be set");
        this.user = (Optional)Preconditions.checkNotNull(user, (Object)"user must be set");
        this.roles = (Optional)Preconditions.checkNotNull(roles, (Object)"roles must be set");
        this.databags = (Optional)Preconditions.checkNotNull(databags, (Object)"databags must be set");
        this.runlist = (RunList)((Optional)Preconditions.checkNotNull(runlist, (Object)"runlist must be set")).or((Object)RunList.builder().build());
        this.user = (Optional)Preconditions.checkNotNull(user, (Object)"user must be set");
        this.cookbookPath = !((Optional)Preconditions.checkNotNull(cookbookPath, (Object)"cookbookPath must be set")).isPresent() || ((ImmutableList)cookbookPath.get()).isEmpty() ? ImmutableList.of((Object)(this.fileCachePath + "/cookbooks")) : ImmutableList.copyOf((Collection)((Collection)cookbookPath.get()));
    }

    @Override
    public String render(OsFamily family) {
        if (family == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        ImmutableList.Builder statements = ImmutableList.builder();
        this.checkChefIsInstalled((ImmutableList.Builder<Statement>)statements);
        this.createSoloConfiguration((ImmutableList.Builder<Statement>)statements);
        this.createRolesIfNecessary((ImmutableList.Builder<Statement>)statements);
        this.createDatabagsIfNecessary((ImmutableList.Builder<Statement>)statements);
        this.createNodeConfiguration((ImmutableList.Builder<Statement>)statements);
        ImmutableMap.Builder options = ImmutableMap.builder();
        options.put((Object)"-c", (Object)(this.fileCachePath + "/solo.rb"));
        options.put((Object)"-j", (Object)(this.fileCachePath + "/node.json"));
        options.put((Object)"-N", this.nodeName.or((Object)"`hostname`"));
        if (this.group.isPresent()) {
            options.put((Object)"-g", this.group.get());
        }
        if (this.interval.isPresent()) {
            options.put((Object)"-i", (Object)((Integer)this.interval.get()).toString());
        }
        if (this.logLevel.isPresent()) {
            options.put((Object)"-l", this.logLevel.get());
        }
        if (this.logFile.isPresent()) {
            options.put((Object)"-L", this.logFile.get());
        }
        if (this.cookbooksArchiveLocation.isPresent()) {
            options.put((Object)"-r", this.cookbooksArchiveLocation.get());
        }
        if (this.splay.isPresent()) {
            options.put((Object)"-s", (Object)((Integer)this.splay.get()).toString());
        }
        if (this.user.isPresent()) {
            options.put((Object)"-u", this.user.get());
        }
        String strOptions = Joiner.on((char)' ').withKeyValueSeparator(" ").join((Map)options.build());
        statements.add((Object)Statements.exec(String.format("chef-solo %s", strOptions)));
        return new StatementList((Iterable<Statement>)statements.build()).render(family);
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return Collections.emptyList();
    }

    private void checkChefIsInstalled(ImmutableList.Builder<Statement> statements) {
        statements.add((Object)Statements.exec("if ! hash chef-solo 2>/dev/null; then"));
        statements.add((Object)Statements.exec("echo 'chef-solo not found. Please, install Chef first'"));
        statements.add((Object)Statements.exec("exit 1"));
        statements.add((Object)Statements.exec("fi"));
    }

    @VisibleForTesting
    void createSoloConfiguration(ImmutableList.Builder<Statement> statements) {
        statements.add((Object)Statements.exec("{md} " + this.fileCachePath));
        for (String path : this.cookbookPath) {
            statements.add((Object)Statements.exec("{md} " + path));
        }
        String cookbookPathJoined = Joiner.on((char)',').join(Iterables.transform(this.cookbookPath, ChefSolo.quote()));
        statements.add((Object)Statements.createOrOverwriteFile(this.fileCachePath + "/solo.rb", (Iterable<String>)ImmutableSet.of((Object)("file_cache_path \"" + this.fileCachePath + "\""), (Object)("cookbook_path [" + cookbookPathJoined + "]"), (Object)("role_path \"" + this.rolePath + "\""), (Object)("data_bag_path \"" + this.databagPath + "\""))));
    }

    @VisibleForTesting
    void createNodeConfiguration(ImmutableList.Builder<Statement> statements) {
        StringBuilder json = new StringBuilder();
        if (this.jsonAttributes.isPresent()) {
            json.append(((String)this.jsonAttributes.get()).substring(0, ((String)this.jsonAttributes.get()).lastIndexOf(125)));
            json.append(",");
        } else {
            json.append("{");
        }
        json.append("\"run_list\":");
        json.append(this.runlist.toString());
        json.append("}");
        statements.add((Object)Statements.createOrOverwriteFile(this.fileCachePath + "/node.json", (Iterable<String>)ImmutableSet.of((Object)json.toString())));
    }

    @VisibleForTesting
    void createRolesIfNecessary(ImmutableList.Builder<Statement> statements) {
        if (this.roles.isPresent() && !((List)this.roles.get()).isEmpty()) {
            statements.add((Object)Statements.exec("{md} " + this.rolePath));
            for (Role role : (List)this.roles.get()) {
                statements.add((Object)Statements.createOrOverwriteFile(this.rolePath + "/" + role.getName() + ".json", (Iterable<String>)ImmutableSet.of((Object)role.toJsonString())));
            }
        }
    }

    @VisibleForTesting
    void createDatabagsIfNecessary(ImmutableList.Builder<Statement> statements) {
        if (this.databags.isPresent() && !((List)this.databags.get()).isEmpty()) {
            statements.add((Object)Statements.exec("{md} " + this.databagPath));
            for (DataBag databag : (List)this.databags.get()) {
                String databagFolder = this.databagPath + "/" + databag.getName();
                statements.add((Object)Statements.exec("{md} " + databagFolder));
                for (Map.Entry<String, String> item : databag.getItems().entrySet()) {
                    statements.add((Object)Statements.createOrOverwriteFile(databagFolder + "/" + item.getKey() + ".json", (Iterable<String>)ImmutableSet.of((Object)item.getValue())));
                }
            }
        }
    }

    private static Function<String, String> quote() {
        return new Function<String, String>(){

            public String apply(String input) {
                return "\"" + input + "\"";
            }
        };
    }

    public static class Builder {
        private String fileCachePath = "/var/chef";
        private String rolePath;
        private String databagPath;
        private ImmutableList.Builder<String> cookbookPath = ImmutableList.builder();
        private String cookbooksArchiveLocation;
        private String jsonAttributes;
        private String group;
        private Integer interval;
        private String logLevel;
        private String logFile;
        private String nodeName;
        private Integer splay;
        private String user;
        private List<Role> roles = Lists.newArrayList();
        private List<DataBag> databags = Lists.newArrayList();
        private RunList runlist;

        public Builder fileCachePath(String fileCachePath) {
            this.fileCachePath = (String)Preconditions.checkNotNull((Object)fileCachePath, (Object)"fileCachePath");
            return this;
        }

        public Builder rolePath(String rolePath) {
            this.rolePath = (String)Preconditions.checkNotNull((Object)rolePath, (Object)"rolePath");
            return this;
        }

        public Builder dataBagPath(String dataBagPath) {
            this.databagPath = (String)Preconditions.checkNotNull((Object)dataBagPath, (Object)"dataBagPath");
            return this;
        }

        public Builder cookbookPath(String cookbookPath) {
            this.cookbookPath.add(Preconditions.checkNotNull((Object)cookbookPath, (Object)"cookbookPath"));
            return this;
        }

        public Builder cookbookPaths(Iterable<String> cookbookPaths) {
            this.cookbookPath.addAll((Iterable)Preconditions.checkNotNull(cookbookPaths, (Object)"cookbookPath"));
            return this;
        }

        public Builder cookbooksArchiveLocation(String cookbooksArchiveLocation) {
            this.cookbooksArchiveLocation = (String)Preconditions.checkNotNull((Object)cookbooksArchiveLocation, (Object)"cookbooksArchiveLocation");
            return this;
        }

        public Builder jsonAttributes(String jsonAttributes) {
            this.jsonAttributes = (String)Preconditions.checkNotNull((Object)jsonAttributes, (Object)"jsonAttributes");
            return this;
        }

        public Builder group(String group) {
            this.group = (String)Preconditions.checkNotNull((Object)group, (Object)"group");
            return this;
        }

        public Builder interval(Integer interval) {
            this.interval = (Integer)Preconditions.checkNotNull((Object)interval, (Object)"interval");
            return this;
        }

        public Builder logLevel(String logLevel) {
            this.logLevel = (String)Preconditions.checkNotNull((Object)logLevel, (Object)"logLevel");
            return this;
        }

        public Builder logFile(String logFile) {
            this.logFile = (String)Preconditions.checkNotNull((Object)logFile, (Object)"logFile");
            return this;
        }

        public Builder nodeName(String nodeName) {
            this.nodeName = (String)Preconditions.checkNotNull((Object)nodeName, (Object)"nodeName");
            return this;
        }

        public Builder splay(Integer splay) {
            this.splay = (Integer)Preconditions.checkNotNull((Object)splay, (Object)"splay");
            return this;
        }

        public Builder user(String user) {
            this.user = (String)Preconditions.checkNotNull((Object)user, (Object)"user");
            return this;
        }

        public Builder defineRole(Role role) {
            this.roles.add((Role)Preconditions.checkNotNull((Object)role, (Object)"role"));
            return this;
        }

        public Builder defineRoles(Iterable<Role> roles) {
            this.roles = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(roles, (Object)"roles")));
            return this;
        }

        public Builder defineDataBag(DataBag dataBag) {
            this.databags.add((DataBag)((Object)Preconditions.checkNotNull((Object)((Object)dataBag), (Object)"dataBag")));
            return this;
        }

        public Builder defineDataBags(Iterable<DataBag> databags) {
            this.databags = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(databags, (Object)"databags")));
            return this;
        }

        public Builder runlist(RunList runlist) {
            this.runlist = (RunList)Preconditions.checkNotNull((Object)runlist, (Object)"runlist");
            return this;
        }

        public ChefSolo build() {
            return new ChefSolo((Optional<String>)Optional.of((Object)this.fileCachePath), (Optional<String>)Optional.fromNullable((Object)this.rolePath), (Optional<String>)Optional.fromNullable((Object)this.databagPath), (Optional<ImmutableList<String>>)Optional.of((Object)this.cookbookPath.build()), (Optional<String>)Optional.fromNullable((Object)this.cookbooksArchiveLocation), (Optional<String>)Optional.fromNullable((Object)this.jsonAttributes), (Optional<String>)Optional.fromNullable((Object)this.group), (Optional<Integer>)Optional.fromNullable((Object)this.interval), (Optional<String>)Optional.fromNullable((Object)this.logLevel), (Optional<String>)Optional.fromNullable((Object)this.logFile), (Optional<String>)Optional.fromNullable((Object)this.nodeName), (Optional<Integer>)Optional.fromNullable((Object)this.splay), (Optional<String>)Optional.fromNullable((Object)this.user), (Optional<List<Role>>)Optional.of(this.roles), (Optional<List<DataBag>>)Optional.of(this.databags), (Optional<RunList>)Optional.fromNullable((Object)this.runlist));
        }
    }
}

