/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.git;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import org.jclouds.scriptbuilder.domain.GitRepoAndRef;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class CloneGitRepo
implements Statement {
    protected final GitRepoAndRef gitRepoAndRef;
    protected final Optional<String> directory;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromCloneGitRepo(this);
    }

    protected CloneGitRepo(GitRepoAndRef gitRepoAndRef, Optional<String> directory) {
        this.gitRepoAndRef = (GitRepoAndRef)Preconditions.checkNotNull((Object)gitRepoAndRef, (Object)"gitRepoAndRef");
        this.directory = (Optional)Preconditions.checkNotNull(directory, (Object)"directory");
    }

    public GitRepoAndRef getGitRepoAndRef() {
        return this.gitRepoAndRef;
    }

    public Optional<String> getDirectory() {
        return this.directory;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.gitRepoAndRef, this.directory});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CloneGitRepo other = (CloneGitRepo)CloneGitRepo.class.cast(obj);
        return Objects.equal((Object)this.gitRepoAndRef, (Object)other.gitRepoAndRef) && Objects.equal(this.directory, other.directory);
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily arg0) {
        return ImmutableSet.of();
    }

    @Override
    public String render(OsFamily arg0) {
        StringBuilder command = new StringBuilder();
        command.append("git clone");
        if (this.gitRepoAndRef.getBranch().isPresent()) {
            command.append(" -b ").append((String)this.gitRepoAndRef.getBranch().get());
        }
        command.append(' ').append(this.gitRepoAndRef.getRepository().toASCIIString());
        if (this.directory.isPresent()) {
            command.append(' ').append((String)this.directory.get());
        }
        command.append("{lf}");
        command.append("{cd} ").append((String)this.directory.or((Object)((String)Iterables.getLast((Iterable)Splitter.on((char)'/').split((CharSequence)this.gitRepoAndRef.getRepository().getPath()))).replace(".git", "")));
        if (this.gitRepoAndRef.getTag().isPresent()) {
            command.append("{lf}").append("git checkout ").append((String)this.gitRepoAndRef.getTag().get());
        }
        return Statements.exec(command.toString()).render(arg0);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("gitRepoAndRef", (Object)this.gitRepoAndRef).add("directory", this.directory.orNull()).toString();
    }

    public static class Builder {
        protected GitRepoAndRef.Builder gitRepoAndRef = GitRepoAndRef.builder();
        protected Optional<String> directory = Optional.absent();

        public Builder repository(URI repository) {
            this.gitRepoAndRef.repository(repository);
            return this;
        }

        public Builder repository(String repository) {
            return this.repository(URI.create(repository));
        }

        public Builder branch(String branch) {
            this.gitRepoAndRef.branch(branch);
            return this;
        }

        public Builder tag(String tag) {
            this.gitRepoAndRef.tag(tag);
            return this;
        }

        public Builder gitRepoAndRef(GitRepoAndRef gitRepoAndRef) {
            this.gitRepoAndRef.fromGitRepoAndRef(gitRepoAndRef);
            return this;
        }

        public Builder directory(String directory) {
            this.directory = Optional.fromNullable((Object)directory);
            return this;
        }

        public CloneGitRepo build() {
            return new CloneGitRepo(this.gitRepoAndRef.build(), this.directory);
        }

        public Builder fromCloneGitRepo(CloneGitRepo in) {
            return this.gitRepoAndRef(in.getGitRepoAndRef()).directory((String)in.getDirectory().orNull());
        }
    }
}

