/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RequestView;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class RequestPanel {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final LinkedList<RequestView> listRequestView = new LinkedList();
    private final JPanel panel;

    public RequestPanel() {
        List classesToAdd = Collections.emptyList();
        try {
            classesToAdd = JMeterUtils.findClassesThatExtend(RequestView.class);
        }
        catch (IOException e1) {
            // empty catch block
        }
        String rawTab = JMeterUtils.getResString((String)"view_results_table_request_tab_raw");
        RequestView rawObject = null;
        for (String clazz : classesToAdd) {
            try {
                RequestView requestView = (RequestView)Class.forName(clazz).newInstance();
                if (rawTab.equals(requestView.getLabel())) {
                    rawObject = requestView;
                    continue;
                }
                this.listRequestView.add(requestView);
            }
            catch (Exception e) {
                log.warn("Error in load result render:" + clazz, (Throwable)e);
            }
        }
        if (rawObject != null) {
            this.listRequestView.addFirst(rawObject);
        }
        JTabbedPane tabbedRequest = new JTabbedPane(3);
        for (RequestView requestView : this.listRequestView) {
            requestView.init();
            tabbedRequest.addTab(requestView.getLabel(), requestView.getPanel());
        }
        this.panel = new JPanel(new BorderLayout());
        this.panel.add(tabbedRequest);
    }

    public void clearData() {
        for (RequestView requestView : this.listRequestView) {
            requestView.clearData();
        }
    }

    public void setSamplerResult(SampleResult samplerResult) {
        for (RequestView requestView : this.listRequestView) {
            requestView.setSamplerResult(samplerResult);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

