/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config;

import java.io.IOException;
import java.util.List;
import org.apache.jmeter.config.CSVDataSetBeanInfo;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.engine.util.NoConfigMerge;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterStopThreadException;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVDataSet
extends ConfigTestElement
implements TestBean,
LoopIterationListener,
NoConfigMerge {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 232L;
    private static final String EOFVALUE = JMeterUtils.getPropDefault((String)"csvdataset.eofstring", (String)"<EOF>");
    private transient String filename;
    private transient String fileEncoding;
    private transient String variableNames;
    private transient String delimiter;
    private transient boolean quoted;
    private transient boolean recycle = true;
    private transient boolean stopThread;
    private transient String[] vars;
    private transient String alias;
    private transient String shareMode;
    private boolean firstLineIsNames = false;

    private Object readResolve() {
        this.recycle = true;
        return this;
    }

    public void iterationStart(LoopIterationEvent iterEvent) {
        FileServer server = FileServer.getFileServer();
        JMeterContext context = this.getThreadContext();
        String delim = this.getDelimiter();
        if (delim.equals("\\t")) {
            delim = "\t";
        } else if (delim.length() == 0) {
            log.warn("Empty delimiter converted to ','");
            delim = ",";
        }
        if (this.vars == null) {
            String _fileName = this.getFilename();
            String mode = this.getShareMode();
            int modeInt = CSVDataSetBeanInfo.getShareModeAsInt(mode);
            switch (modeInt) {
                case 0: {
                    this.alias = _fileName;
                    break;
                }
                case 1: {
                    this.alias = _fileName + "@" + System.identityHashCode(context.getThreadGroup());
                    break;
                }
                case 2: {
                    this.alias = _fileName + "@" + System.identityHashCode(context.getThread());
                    break;
                }
                default: {
                    this.alias = _fileName + "@" + mode;
                }
            }
            String names = this.getVariableNames();
            if (names == null || names.length() == 0) {
                String header = server.reserveFile(_fileName, this.getFileEncoding(), this.alias, true);
                try {
                    this.vars = CSVSaveService.csvSplitString((String)header, (char)delim.charAt(0));
                    this.firstLineIsNames = true;
                }
                catch (IOException e) {
                    log.warn("Could not split CSV header line", (Throwable)e);
                }
            } else {
                server.reserveFile(_fileName, this.getFileEncoding(), this.alias);
                this.vars = JOrphanUtils.split((String)names, (String)",");
            }
        }
        JMeterVariables threadVars = context.getVariables();
        String line = null;
        try {
            line = server.readLine(this.alias, this.getRecycle(), this.firstLineIsNames);
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        if (line != null) {
            try {
                String[] lineValues = this.getQuotedData() ? CSVSaveService.csvSplitString((String)line, (char)delim.charAt(0)) : JOrphanUtils.split((String)line, (String)delim, (boolean)false);
                for (int a = 0; a < this.vars.length && a < lineValues.length; ++a) {
                    threadVars.put(this.vars[a], lineValues[a]);
                }
            }
            catch (IOException e) {
                log.error("Unexpected error splitting '" + line + "' on '" + delim.charAt(0) + "'");
            }
        } else {
            if (this.getStopThread()) {
                throw new JMeterStopThreadException("End of file detected");
            }
            for (int a = 0; a < this.vars.length; ++a) {
                threadVars.put(this.vars[a], EOFVALUE);
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public String getVariableNames() {
        return this.variableNames;
    }

    public void setVariableNames(String variableNames) {
        this.variableNames = variableNames;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean getQuotedData() {
        return this.quoted;
    }

    public void setQuotedData(boolean quoted) {
        this.quoted = quoted;
    }

    public boolean getRecycle() {
        return this.recycle;
    }

    public void setRecycle(boolean recycle) {
        this.recycle = recycle;
    }

    public boolean getStopThread() {
        return this.stopThread;
    }

    public void setStopThread(boolean value) {
        this.stopThread = value;
    }

    public String getShareMode() {
        return this.shareMode;
    }

    public void setShareMode(String value) {
        this.shareMode = value;
    }

    public List<String> getSearchableTokens() throws Exception {
        List result = super.getSearchableTokens();
        result.add(this.getPropertyAsString("variableNames"));
        return result;
    }
}

