/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.assertions.CompareAssertionResult;
import org.apache.jmeter.assertions.SubstitutionElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareAssertion
extends AbstractTestElement
implements Assertion,
TestBean,
Serializable,
LoopIterationListener {
    private static final long serialVersionUID = 240L;
    private transient List<SampleResult> responses;
    private final transient StringSubstitution emptySub = new StringSubstitution("");
    private boolean compareContent = true;
    private long compareTime = -1L;
    private Collection<SubstitutionElement> stringsToSkip;

    public AssertionResult getResult(SampleResult response) {
        this.responses.add(response);
        if (this.responses.size() > 1) {
            CompareAssertionResult result = new CompareAssertionResult(this.getName());
            this.compareContent(result);
            this.compareTime(result);
            return result;
        }
        return new AssertionResult(this.getName());
    }

    private void compareTime(CompareAssertionResult result) {
        if (this.compareTime >= 0L) {
            long prevTime = -1L;
            SampleResult prevResult = null;
            boolean success = true;
            StringBuilder buf = new StringBuilder();
            for (SampleResult sResult : this.responses) {
                long currentTime = sResult.getTime();
                if (prevTime != -1L) {
                    success = Math.abs(prevTime - currentTime) <= this.compareTime;
                    prevResult = sResult;
                }
                if (!success) {
                    result.setFailure(true);
                    buf.setLength(0);
                    this.appendResultDetails(buf, prevResult);
                    buf.append(JMeterUtils.getResString((String)"comparison_response_time")).append(prevTime);
                    result.addToBaseResult(buf.toString());
                    buf.setLength(0);
                    this.appendResultDetails(buf, sResult);
                    buf.append(JMeterUtils.getResString((String)"comparison_response_time")).append(currentTime);
                    result.addToSecondaryResult(buf.toString());
                    result.setFailureMessage(JMeterUtils.getResString((String)"comparison_differ_time") + this.compareTime + JMeterUtils.getResString((String)"comparison_unit"));
                    break;
                }
                prevResult = sResult;
                prevTime = currentTime;
            }
        }
    }

    private void compareContent(CompareAssertionResult result) {
        if (this.compareContent) {
            String prevContent = null;
            SampleResult prevResult = null;
            boolean success = true;
            StringBuilder buf = new StringBuilder();
            for (SampleResult sResult : this.responses) {
                String currentContent = sResult.getResponseDataAsString();
                currentContent = this.filterString(currentContent);
                if (prevContent != null) {
                    success = prevContent.equals(currentContent);
                }
                if (!success) {
                    result.setFailure(true);
                    buf.setLength(0);
                    this.appendResultDetails(buf, prevResult);
                    buf.append(prevContent);
                    result.addToBaseResult(buf.toString());
                    buf.setLength(0);
                    this.appendResultDetails(buf, sResult);
                    buf.append(currentContent);
                    result.addToSecondaryResult(buf.toString());
                    result.setFailureMessage(JMeterUtils.getResString((String)"comparison_differ_content"));
                    break;
                }
                prevResult = sResult;
                prevContent = currentContent;
            }
        }
    }

    private void appendResultDetails(StringBuilder buf, SampleResult result) {
        String samplerData = result.getSamplerData();
        if (samplerData != null) {
            buf.append(samplerData.trim());
        }
        buf.append("\n");
        String requestHeaders = result.getRequestHeaders();
        if (requestHeaders != null) {
            buf.append(requestHeaders);
        }
        buf.append("\n\n");
    }

    private String filterString(String content) {
        if (this.stringsToSkip == null || this.stringsToSkip.size() == 0) {
            return content;
        }
        for (SubstitutionElement regex : this.stringsToSkip) {
            this.emptySub.setSubstitution(regex.getSubstitute());
            content = Util.substitute((PatternMatcher)JMeterUtils.getMatcher(), (Pattern)JMeterUtils.getPatternCache().getPattern(regex.getRegex()), (Substitution)this.emptySub, (String)content, (int)-1);
        }
        return content;
    }

    public void iterationStart(LoopIterationEvent iterEvent) {
        this.responses = new LinkedList<SampleResult>();
    }

    public void iterationEnd(LoopIterationEvent iterEvent) {
        this.responses = null;
    }

    public boolean isCompareContent() {
        return this.compareContent;
    }

    public void setCompareContent(boolean compareContent) {
        this.compareContent = compareContent;
    }

    public long getCompareTime() {
        return this.compareTime;
    }

    public void setCompareTime(long compareTime) {
        this.compareTime = compareTime;
    }

    public Collection<SubstitutionElement> getStringsToSkip() {
        return this.stringsToSkip;
    }

    public void setStringsToSkip(Collection<SubstitutionElement> stringsToSkip) {
        this.stringsToSkip = stringsToSkip;
    }
}

