/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.SamplerResultTab;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;

public class RenderAsJSON
extends SamplerResultTab
implements ResultRenderer {
    private static final String ESC_CHAR_REGEX = "\\\\[\"\\\\/bfnrt]|\\\\u[0-9A-Fa-f]{4}";
    private static final String NORMAL_CHARACTER_REGEX = "[^\"\\\\]";
    private static final String STRING_REGEX = "\"(\\\\[\"\\\\/bfnrt]|\\\\u[0-9A-Fa-f]{4}|[^\"\\\\])*\"";
    private static final String OTHER_VALUE_REGEX = "[^\\{\\[\\]\\}\\,]*";
    private static final String VALUE_OR_PAIR_REGEX = "((\"(\\\\[\"\\\\/bfnrt]|\\\\u[0-9A-Fa-f]{4}|[^\"\\\\])*\"\\s*:)?\\s*(\"(\\\\[\"\\\\/bfnrt]|\\\\u[0-9A-Fa-f]{4}|[^\"\\\\])*\"|[^\\{\\[\\]\\}\\,]*)\\s*,?\\s*)";
    private static final Pattern VALUE_OR_PAIR_PATTERN = Pattern.compile("((\"(\\\\[\"\\\\/bfnrt]|\\\\u[0-9A-Fa-f]{4}|[^\"\\\\])*\"\\s*:)?\\s*(\"(\\\\[\"\\\\/bfnrt]|\\\\u[0-9A-Fa-f]{4}|[^\"\\\\])*\"|[^\\{\\[\\]\\}\\,]*)\\s*,?\\s*)");

    public void renderResult(SampleResult sampleResult) {
        String response = ViewResultsFullVisualizer.getResponseAsString(sampleResult);
        this.showRenderJSONResponse(response);
    }

    private void showRenderJSONResponse(String response) {
        this.results.setContentType("text/plain");
        this.results.setText(response == null ? "" : RenderAsJSON.prettyJSON(response));
        this.results.setCaretPosition(0);
        this.resultsScrollPane.setViewportView(this.results);
    }

    private static String prettyJSON(String json) {
        StringBuilder pretty = new StringBuilder(json.length() * 2);
        String tab = ":   ";
        StringBuilder index = new StringBuilder();
        String nl = "";
        Matcher valueOrPair = VALUE_OR_PAIR_PATTERN.matcher(json);
        boolean misparse = false;
        int i = 0;
        while (i < json.length()) {
            char currentChar = json.charAt(i);
            if (currentChar == '{' || currentChar == '[') {
                pretty.append(nl).append((CharSequence)index).append(currentChar);
                ++i;
                index.append(":   ");
                misparse = false;
            } else if (currentChar == '}' || currentChar == ']') {
                int j;
                if (index.length() > 0) {
                    index.delete(0, ":   ".length());
                }
                pretty.append(nl).append((CharSequence)index).append(currentChar);
                for (j = ++i; j < json.length() && Character.isWhitespace(json.charAt(j)); ++j) {
                }
                if (j < json.length() && json.charAt(j) == ',') {
                    pretty.append(",");
                    i = j + 1;
                }
                misparse = false;
            } else if (valueOrPair.find(i) && valueOrPair.group().length() > 0) {
                pretty.append(nl).append((CharSequence)index).append(valueOrPair.group());
                i = valueOrPair.end();
                misparse = false;
            } else {
                if (!misparse) {
                    pretty.append(nl).append("- Parse failed from:");
                }
                pretty.append(currentChar);
                ++i;
                misparse = true;
            }
            nl = "\n";
        }
        return pretty.toString();
    }

    public String toString() {
        return JMeterUtils.getResString((String)"view_results_render_json");
    }
}

