/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.control.TransactionSampler;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.SamplePackage;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TransactionController
extends GenericController
implements SampleListener,
Controller,
Serializable {
    private static final long serialVersionUID = 233L;
    private static final String TRUE = Boolean.toString(true);
    private static final String PARENT = "TransactionController.parent";
    private static final String INCLUDE_TIMERS = "TransactionController.includeTimers";
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final boolean DEFAULT_VALUE_FOR_INCLUDE_TIMERS = true;
    private transient TransactionSampler transactionSampler;
    private transient ListenerNotifier lnf = new ListenerNotifier();
    private transient SampleResult res;
    private transient int calls;
    private transient int noFailingSamples;
    private transient long pauseTime;
    private transient long prevEndTime;

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.lnf = new ListenerNotifier();
        return this;
    }

    public void setParent(boolean _parent) {
        this.setProperty(new BooleanProperty(PARENT, _parent));
    }

    public boolean isParent() {
        return this.getPropertyAsBoolean(PARENT);
    }

    @Override
    public Sampler next() {
        if (this.isParent()) {
            return this.next1();
        }
        return this.next2();
    }

    private Sampler next1() {
        if (this.transactionSampler != null && this.transactionSampler.isTransactionDone()) {
            if (log.isDebugEnabled()) {
                log.debug("End of transaction " + this.getName());
            }
            this.transactionSampler = null;
            return null;
        }
        if (this.isFirst()) {
            if (log.isDebugEnabled()) {
                log.debug("Start of transaction " + this.getName());
            }
            this.transactionSampler = new TransactionSampler(this, this.getName());
        }
        Sampler subSampler = super.next();
        this.transactionSampler.setSubSampler(subSampler);
        if (subSampler == null) {
            this.transactionSampler.setTransactionDone();
        }
        return this.transactionSampler;
    }

    @Override
    protected Sampler nextIsAController(Controller controller) throws NextIsNullException {
        Sampler returnValue;
        if (!this.isParent()) {
            return super.nextIsAController(controller);
        }
        Sampler sampler = controller.next();
        if (sampler == null) {
            this.currentReturnedNull(controller);
            returnValue = super.next();
        } else {
            returnValue = sampler;
        }
        return returnValue;
    }

    private Sampler next2() {
        if (this.isFirst()) {
            this.calls = 0;
            this.noFailingSamples = 0;
            this.res = new SampleResult();
            this.res.setSampleLabel(this.getName());
            this.res.setSuccessful(true);
            this.res.sampleStart();
            this.prevEndTime = this.res.getStartTime();
            this.pauseTime = 0L;
        }
        boolean isLast = this.current == this.subControllersAndSamplers.size();
        Sampler returnValue = super.next();
        if (returnValue == null && isLast) {
            if (this.res != null) {
                this.res.setIdleTime(this.pauseTime + this.res.getIdleTime());
                this.res.sampleEnd();
                this.res.setResponseMessage("Number of samples in transaction : " + this.calls + ", number of failing samples : " + this.noFailingSamples);
                if (this.res.isSuccessful()) {
                    this.res.setResponseCodeOK();
                }
                this.notifyListeners();
            }
        } else {
            ++this.calls;
        }
        return returnValue;
    }

    @Override
    public void triggerEndOfLoop() {
        if (!this.isParent()) {
            if (this.res != null) {
                this.res.setIdleTime(this.pauseTime + this.res.getIdleTime());
                this.res.sampleEnd();
                this.res.setSuccessful(TRUE.equals(JMeterContextService.getContext().getVariables().get("JMeterThread.last_sample_ok")));
                this.res.setResponseMessage("Number of samples in transaction : " + this.calls + ", number of failing samples : " + this.noFailingSamples);
                this.notifyListeners();
            }
        } else {
            this.transactionSampler.setTransactionDone();
            this.transactionSampler = null;
        }
        super.triggerEndOfLoop();
    }

    protected void notifyListeners() {
        JMeterContext threadContext = this.getThreadContext();
        JMeterVariables threadVars = threadContext.getVariables();
        SamplePackage pack = (SamplePackage)threadVars.getObject("JMeterThread.pack");
        if (pack == null) {
            log.warn("Could not fetch SamplePackage");
        } else {
            SampleEvent event = new SampleEvent(this.res, threadContext.getThreadGroup().getName(), threadVars, true);
            this.res = null;
            if (!this.getThreadContext().isReinitializingSubControllers()) {
                this.lnf.notifyListeners(event, pack.getSampleListeners());
            }
        }
    }

    @Override
    public void sampleOccurred(SampleEvent se) {
        if (!this.isParent() && this.res != null && !se.isTransactionSampleEvent()) {
            SampleResult sampleResult = se.getResult();
            this.res.setThreadName(sampleResult.getThreadName());
            this.res.setBytes(this.res.getBytes() + sampleResult.getBytes());
            if (!this.isIncludeTimers()) {
                this.pauseTime += sampleResult.getEndTime() - sampleResult.getTime() - this.prevEndTime;
                this.prevEndTime = sampleResult.getEndTime();
            }
            if (!sampleResult.isSuccessful()) {
                this.res.setSuccessful(false);
                ++this.noFailingSamples;
            }
            this.res.setAllThreads(sampleResult.getAllThreads());
            this.res.setGroupThreads(sampleResult.getGroupThreads());
            this.res.setLatency(this.res.getLatency() + sampleResult.getLatency());
        }
    }

    @Override
    public void sampleStarted(SampleEvent e) {
    }

    @Override
    public void sampleStopped(SampleEvent e) {
    }

    public void setIncludeTimers(boolean includeTimers) {
        this.setProperty(INCLUDE_TIMERS, includeTimers, true);
    }

    public boolean isIncludeTimers() {
        return this.getPropertyAsBoolean(INCLUDE_TIMERS, true);
    }
}

