/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditorSupport;
import javax.swing.JPasswordField;

public class PasswordEditor
extends PropertyEditorSupport
implements ActionListener,
FocusListener {
    private JPasswordField textField = new JPasswordField();
    private String initialValue = "";

    protected PasswordEditor() {
        this.textField.addActionListener(this);
        this.textField.addFocusListener(this);
    }

    @Override
    public String getAsText() {
        return new String(this.textField.getPassword());
    }

    @Override
    public void setAsText(String value) {
        this.initialValue = value;
        this.textField.setText(value);
    }

    @Override
    public Object getValue() {
        return this.getAsText();
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException();
        }
        this.setAsText((String)value);
    }

    @Override
    public Component getCustomEditor() {
        return this.textField;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void firePropertyChange() {
        String newValue = this.getAsText();
        if (this.initialValue.equals(newValue)) {
            return;
        }
        this.initialValue = newValue;
        super.firePropertyChange();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.firePropertyChange();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.firePropertyChange();
    }
}

