/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.JMeterFileFilter;

public final class FileDialoger {
    private static String lastJFCDirectory = null;
    private static JFileChooser jfc = new JFileChooser();

    private FileDialoger() {
    }

    public static JFileChooser promptToOpenFile() {
        return FileDialoger.promptToOpenFile((String)null);
    }

    public static JFileChooser promptToOpenFile(String existingFileName) {
        return FileDialoger.promptToOpenFile(new String[0], existingFileName);
    }

    public static JFileChooser promptToOpenFile(String[] exts) {
        return FileDialoger.promptToOpenFile(exts, null);
    }

    public static JFileChooser promptToOpenFile(String[] exts, String existingFileName) {
        String start;
        if (!StringUtils.isEmpty((CharSequence)existingFileName)) {
            File existingFileStart = new File(existingFileName);
            if (existingFileStart.exists() && existingFileStart.canRead()) {
                jfc.setCurrentDirectory(new File(existingFileName));
            }
        } else if (lastJFCDirectory == null && (start = System.getProperty("user.dir", "")).length() > 0) {
            jfc.setCurrentDirectory(new File(start));
        }
        FileDialoger.clearFileFilters();
        if (exts != null && exts.length > 0) {
            JMeterFileFilter currentFilter = new JMeterFileFilter(exts);
            jfc.addChoosableFileFilter(currentFilter);
            jfc.setAcceptAllFileFilterUsed(true);
            jfc.setFileFilter(currentFilter);
        }
        if (lastJFCDirectory == null) {
            lastJFCDirectory = System.getProperty("user.dir", "");
        }
        jfc.setCurrentDirectory(new File(lastJFCDirectory));
        int retVal = jfc.showOpenDialog(GuiPackage.getInstance().getMainFrame());
        lastJFCDirectory = jfc.getCurrentDirectory().getAbsolutePath();
        if (retVal == 0) {
            return jfc;
        }
        return null;
    }

    private static void clearFileFilters() {
        FileFilter[] filters;
        for (FileFilter filter : filters = jfc.getChoosableFileFilters()) {
            jfc.removeChoosableFileFilter(filter);
        }
    }

    public static JFileChooser promptToSaveFile(String filename) {
        return FileDialoger.promptToSaveFile(filename, null);
    }

    public static JFileChooser promptToSaveFile(String filename, String[] extensions) {
        if (lastJFCDirectory == null) {
            String start = System.getProperty("user.dir", "");
            if (start.length() > 0) {
                jfc = new JFileChooser(new File(start));
            }
            lastJFCDirectory = jfc.getCurrentDirectory().getAbsolutePath();
        }
        String ext = ".jmx";
        if (filename != null) {
            jfc.setDialogTitle(filename);
            jfc.setSelectedFile(filename.lastIndexOf(System.getProperty("file.separator")) > 0 ? new File(filename) : new File(lastJFCDirectory, filename));
            int i = -1;
            i = filename.lastIndexOf(46);
            if (i > -1) {
                ext = filename.substring(i);
            }
        }
        FileDialoger.clearFileFilters();
        if (extensions != null) {
            jfc.addChoosableFileFilter(new JMeterFileFilter(extensions));
        } else {
            jfc.addChoosableFileFilter(new JMeterFileFilter(new String[]{ext}));
        }
        int retVal = jfc.showSaveDialog(GuiPackage.getInstance().getMainFrame());
        jfc.setDialogTitle(null);
        lastJFCDirectory = jfc.getCurrentDirectory().getAbsolutePath();
        if (retVal == 0) {
            return jfc;
        }
        return null;
    }

    public static String getLastJFCDirectory() {
        return lastJFCDirectory;
    }

    public static void setLastJFCDirectory(String lastJFCDirectory) {
        FileDialoger.lastJFCDirectory = lastJFCDirectory;
    }
}

