/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.util.Properties;
import org.apache.jmeter.util.JMeterUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RUndoManager;

public class JSyntaxTextArea
extends RSyntaxTextArea {
    private static final long serialVersionUID = 210L;
    private final Properties languageProperties = JMeterUtils.loadProperties("org/apache/jmeter/gui/util/textarea.properties");
    private final boolean disableUndo;
    private static final boolean WRAP_STYLE_WORD = JMeterUtils.getPropDefault("jsyntaxtextarea.wrapstyleword", true);
    private static final boolean LINE_WRAP = JMeterUtils.getPropDefault("jsyntaxtextarea.linewrap", true);
    private static final boolean CODE_FOLDING = JMeterUtils.getPropDefault("jsyntaxtextarea.codefolding", true);
    private static final int MAX_UNDOS = JMeterUtils.getPropDefault("jsyntaxtextarea.maxundos", 50);

    @Deprecated
    public JSyntaxTextArea() {
        this(30, 50, false);
    }

    public JSyntaxTextArea(int rows, int cols) {
        this(rows, cols, false);
    }

    public JSyntaxTextArea(int rows, int cols, boolean disableUndo) {
        super(rows, cols);
        super.setSyntaxEditingStyle("text/java");
        super.setCodeFoldingEnabled(CODE_FOLDING);
        super.setAntiAliasingEnabled(true);
        super.setLineWrap(LINE_WRAP);
        super.setWrapStyleWord(WRAP_STYLE_WORD);
        this.disableUndo = disableUndo;
    }

    public void setLanguage(String language) {
        if (language == null) {
            super.setSyntaxEditingStyle("text/plain");
        } else {
            String style = this.languageProperties.getProperty(language);
            if (style == null) {
                super.setSyntaxEditingStyle("text/plain");
            } else {
                super.setSyntaxEditingStyle(style);
            }
        }
    }

    protected RUndoManager createUndoManager() {
        RUndoManager undoManager = super.createUndoManager();
        if (this.disableUndo) {
            undoManager.setLimit(0);
        } else {
            undoManager.setLimit(MAX_UNDOS);
        }
        return undoManager;
    }

    public void setInitialText(String string) {
        this.setText(string);
        this.discardAllEdits();
    }
}

