/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.jmeter.reporters.ResultCollectorHelper;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.OldSaveService;
import org.apache.jmeter.save.ScriptWrapper;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.NameUpdater;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class SaveService {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String SAMPLE_EVENT_OBJECT = "SampleEvent";
    public static final String RESULTCOLLECTOR_HELPER_OBJECT = "ResultCollectorHelper";
    public static final String TEST_CLASS_NAME = "TestClassName";
    private static final XStream JMXSAVER = new XStreamWrapper((ReflectionProvider)new PureJavaReflectionProvider());
    private static final XStream JTLSAVER = new XStreamWrapper((ReflectionProvider)new PureJavaReflectionProvider());
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"<ph>\"?>";
    private static final String SAVESERVICE_PROPERTIES_FILE = "/bin/saveservice.properties";
    private static final String SAVESERVICE_PROPERTIES = "saveservice_properties";
    private static final String FILE_FORMAT = "file_format";
    private static final String FILE_FORMAT_TESTPLAN = "file_format.testplan";
    private static final String FILE_FORMAT_TESTLOG = "file_format.testlog";
    private static final String VERSION_2_2 = "2.2";
    public static final String TESTPLAN_FORMAT;
    public static final String TESTLOG_FORMAT;
    public static final boolean IS_TESTPLAN_FORMAT_22;
    private static final Properties aliasToClass;
    private static final Properties classToAlias;
    private static final String VERSION = "1.2";
    private static String propertiesVersion;
    private static final String PROPVERSION = "2.7";
    private static String fileVersion;
    private static final String FILEVERSION = "1618048";
    private static String fileEncoding;
    private static boolean versionsOK;
    private static final String REVPFX = "$Revision: ";
    private static final String REVSFX = " $";

    private static boolean validateFormat(String format) {
        if (VERSION_2_2.equals(format)) {
            return true;
        }
        return "2.1".equals(format);
    }

    private static void makeAlias(String aliasList, String clazz) {
        String[] aliases = aliasList.split(",");
        String alias = aliases[0];
        for (String a : aliases) {
            Object old = aliasToClass.setProperty(a, clazz);
            if (old == null) continue;
            log.error("Duplicate class detected for " + alias + ": " + clazz + " & " + old);
        }
        Object oldval = classToAlias.setProperty(clazz, alias);
        if (oldval != null) {
            log.error("Duplicate alias detected for " + clazz + ": " + alias + " & " + oldval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties() throws IOException {
        Properties nameMap = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(JMeterUtils.getJMeterHome() + JMeterUtils.getPropDefault(SAVESERVICE_PROPERTIES, SAVESERVICE_PROPERTIES_FILE));
            nameMap.load(fis);
        }
        catch (Throwable throwable) {
            JOrphanUtils.closeQuietly(fis);
            throw throwable;
        }
        JOrphanUtils.closeQuietly((Closeable)fis);
        return nameMap;
    }

    private static void initProps() {
        try {
            Properties nameMap = SaveService.loadProperties();
            for (Map.Entry<Object, Object> me : nameMap.entrySet()) {
                String key = (String)me.getKey();
                String val = (String)me.getValue();
                if (!key.startsWith("_")) {
                    SaveService.makeAlias(key, val);
                    continue;
                }
                if (key.equalsIgnoreCase("_version")) {
                    propertiesVersion = val;
                    log.info("Using SaveService properties version " + propertiesVersion);
                    continue;
                }
                if (key.equalsIgnoreCase("_file_version")) {
                    fileVersion = SaveService.extractVersion(val);
                    log.info("Using SaveService properties file version " + fileVersion);
                    continue;
                }
                if (key.equalsIgnoreCase("_file_encoding")) {
                    fileEncoding = val;
                    log.info("Using SaveService properties file encoding " + fileEncoding);
                    continue;
                }
                key = key.substring(1);
                try {
                    String trimmedValue = val.trim();
                    if (trimmedValue.equals("collection") || trimmedValue.equals("mapping")) {
                        SaveService.registerConverter(key, JMXSAVER, true);
                        SaveService.registerConverter(key, JTLSAVER, true);
                        continue;
                    }
                    SaveService.registerConverter(key, JMXSAVER, false);
                    SaveService.registerConverter(key, JTLSAVER, false);
                }
                catch (IllegalAccessException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
                catch (InstantiationException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
                catch (ClassNotFoundException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
                catch (IllegalArgumentException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
                catch (SecurityException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
                catch (InvocationTargetException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
                catch (NoSuchMethodException e1) {
                    log.warn("Can't register a converter: " + key, (Throwable)e1);
                }
            }
        }
        catch (IOException e) {
            log.fatalError("Bad saveservice properties file", (Throwable)e);
            throw new JMeterError("JMeter requires the saveservice properties file to continue");
        }
    }

    private static void registerConverter(String key, XStream jmxsaver, boolean useMapper) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        if (useMapper) {
            jmxsaver.registerConverter((Converter)Class.forName(key).getConstructor(Mapper.class).newInstance(jmxsaver.getMapper()));
        } else {
            jmxsaver.registerConverter((Converter)Class.forName(key).newInstance());
        }
    }

    public static String aliasToClass(String s) {
        String r = aliasToClass.getProperty(s);
        return r == null ? s : r;
    }

    public static String classToAlias(String s) {
        String r = classToAlias.getProperty(s);
        return r == null ? s : r;
    }

    public static void saveTree(HashTree tree, OutputStream out) throws IOException {
        OutputStreamWriter outputStreamWriter = SaveService.getOutputStreamWriter(out);
        SaveService.writeXmlHeader(outputStreamWriter);
        ScriptWrapper wrapper = new ScriptWrapper();
        wrapper.testPlan = tree;
        JMXSAVER.toXML((Object)wrapper, (Writer)outputStreamWriter);
        outputStreamWriter.write(10);
        outputStreamWriter.close();
    }

    public static void saveElement(Object el, OutputStream out) throws IOException {
        OutputStreamWriter outputStreamWriter = SaveService.getOutputStreamWriter(out);
        SaveService.writeXmlHeader(outputStreamWriter);
        JMXSAVER.toXML(el, (Writer)outputStreamWriter);
        outputStreamWriter.close();
    }

    public static Object loadElement(InputStream in) throws IOException {
        InputStreamReader inputStreamReader = SaveService.getInputStreamReader(in);
        Object element = JMXSAVER.fromXML((Reader)inputStreamReader);
        inputStreamReader.close();
        return element;
    }

    public static synchronized void saveSampleResult(SampleEvent evt, Writer writer) throws IOException {
        DataHolder dh = JTLSAVER.newDataHolder();
        dh.put((Object)SAMPLE_EVENT_OBJECT, (Object)evt);
        try {
            JTLSAVER.marshal((Object)evt.getResult(), new XppDriver().createWriter(writer), dh);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Failed marshalling:" + (evt.getResult() != null ? SaveService.showDebuggingInfo(evt.getResult()) : "null"), e);
        }
        writer.write(10);
    }

    private static String showDebuggingInfo(SampleResult result) {
        try {
            return "class:" + result.getClass() + ",content:" + ToStringBuilder.reflectionToString((Object)result);
        }
        catch (Exception e) {
            return "Exception occured creating debug from event, message:" + e.getMessage();
        }
    }

    public static synchronized void saveTestElement(TestElement elem, Writer writer) throws IOException {
        JMXSAVER.toXML((Object)elem, writer);
        writer.write(10);
    }

    private static String extractVersion(String rev) {
        if (rev.length() > REVPFX.length() + REVSFX.length()) {
            return rev.substring(REVPFX.length(), rev.length() - REVSFX.length());
        }
        return rev;
    }

    static boolean checkPropertyVersion() {
        return PROPVERSION.equals(propertiesVersion);
    }

    static boolean checkFileVersion() {
        return FILEVERSION.equals(fileVersion);
    }

    static List<String> checkClasses() {
        ClassLoader classLoader = SaveService.class.getClassLoader();
        ArrayList<String> missingClasses = new ArrayList<String>();
        for (Object clazz : classToAlias.keySet()) {
            String name = (String)clazz;
            if (NameUpdater.isMapped(name)) continue;
            try {
                Class.forName(name, false, classLoader);
            }
            catch (ClassNotFoundException e) {
                log.error("Unexpected entry in saveservice.properties; class does not exist and is not upgraded: " + name);
                missingClasses.add(name);
            }
        }
        return missingClasses;
    }

    static boolean checkVersions() {
        versionsOK = true;
        if (!PROPVERSION.equalsIgnoreCase(propertiesVersion)) {
            log.warn("Bad _version - expected 2.7, found " + propertiesVersion + ".");
        }
        if (versionsOK) {
            log.info("All converter versions present and correct");
        }
        return versionsOK;
    }

    public static void loadTestResults(InputStream reader, ResultCollectorHelper resultCollectorHelper) throws IOException {
        InputStreamReader inputStreamReader = SaveService.getInputStreamReader(reader);
        DataHolder dh = JTLSAVER.newDataHolder();
        dh.put((Object)RESULTCOLLECTOR_HELPER_OBJECT, (Object)resultCollectorHelper);
        JTLSAVER.unmarshal(new XppDriver().createReader(reader), null, dh);
        inputStreamReader.close();
    }

    public static HashTree loadTree(InputStream reader) throws IOException {
        if (!reader.markSupported()) {
            reader = new BufferedInputStream(reader);
        }
        reader.mark(Integer.MAX_VALUE);
        ScriptWrapper wrapper = null;
        try {
            InputStreamReader inputStreamReader = SaveService.getInputStreamReader(reader);
            wrapper = (ScriptWrapper)JMXSAVER.fromXML((Reader)inputStreamReader);
            inputStreamReader.close();
            if (wrapper == null) {
                log.error("Problem loading XML: see above.");
                return null;
            }
            return wrapper.testPlan;
        }
        catch (CannotResolveClassException e) {
            if (e.getMessage().startsWith("node")) {
                log.info("Problem loading XML, trying Avalon format");
                reader.reset();
                return OldSaveService.loadSubTree(reader);
            }
            log.warn("Problem loading XML, cannot determine class for element: " + e.getLocalizedMessage());
            return null;
        }
        catch (NoClassDefFoundError e) {
            log.error("Missing class " + e);
            return null;
        }
        catch (ConversionException e) {
            log.error("Conversion error " + (Object)((Object)e));
            return null;
        }
    }

    private static InputStreamReader getInputStreamReader(InputStream inStream) {
        Charset charset = SaveService.getFileEncodingCharset();
        if (charset != null) {
            return new InputStreamReader(inStream, charset);
        }
        return new InputStreamReader(inStream);
    }

    private static OutputStreamWriter getOutputStreamWriter(OutputStream outStream) {
        Charset charset = SaveService.getFileEncodingCharset();
        if (charset != null) {
            return new OutputStreamWriter(outStream, charset);
        }
        return new OutputStreamWriter(outStream);
    }

    public static String getFileEncoding(String dflt) {
        if (fileEncoding != null && fileEncoding.length() > 0) {
            return fileEncoding;
        }
        return dflt;
    }

    private static Charset getFileEncodingCharset() {
        if (fileEncoding != null && fileEncoding.length() > 0) {
            return Charset.forName(fileEncoding);
        }
        return null;
    }

    private static void writeXmlHeader(OutputStreamWriter writer) throws IOException {
        Charset charset = SaveService.getFileEncodingCharset();
        if (charset != null) {
            String header = XML_HEADER.replaceAll("<ph>", charset.name());
            writer.write(header);
            writer.write(10);
        }
    }

    public static String CEtoString(ConversionException ce) {
        String msg = "XStream ConversionException at line: " + ce.get("line number") + "\n" + ce.get("message") + "\nPerhaps a missing jar? See log file.";
        return msg;
    }

    public static String getPropertiesVersion() {
        return propertiesVersion;
    }

    public static String getVERSION() {
        return VERSION;
    }

    static {
        JTLSAVER.setMode(1001);
        TESTPLAN_FORMAT = JMeterUtils.getPropDefault(FILE_FORMAT_TESTPLAN, JMeterUtils.getPropDefault(FILE_FORMAT, VERSION_2_2));
        TESTLOG_FORMAT = JMeterUtils.getPropDefault(FILE_FORMAT_TESTLOG, JMeterUtils.getPropDefault(FILE_FORMAT, VERSION_2_2));
        if (!SaveService.validateFormat(TESTPLAN_FORMAT)) {
            log.error("Invalid test plan format: " + TESTPLAN_FORMAT);
        }
        if (!SaveService.validateFormat(TESTLOG_FORMAT)) {
            log.error("Invalid test log format: " + TESTLOG_FORMAT);
        }
        IS_TESTPLAN_FORMAT_22 = VERSION_2_2.equals(TESTPLAN_FORMAT);
        aliasToClass = new Properties();
        classToAlias = new Properties();
        propertiesVersion = "";
        fileVersion = "";
        fileEncoding = "";
        log.info("Testplan (JMX) version: " + TESTPLAN_FORMAT + ". Testlog (JTL) version: " + TESTLOG_FORMAT);
        SaveService.initProps();
        SaveService.checkVersions();
        versionsOK = true;
    }

    private static final class XStreamWrapper
    extends XStream {
        private XStreamWrapper(ReflectionProvider reflectionProvider) {
            super(reflectionProvider);
        }

        protected MapperWrapper wrapMapper(MapperWrapper next) {
            return new MapperWrapper((Mapper)next){

                public Class<?> realClass(String alias) {
                    String fullName = SaveService.aliasToClass(alias);
                    if (fullName != null) {
                        fullName = NameUpdater.getCurrentName(fullName);
                    }
                    return super.realClass(fullName == null ? alias : fullName);
                }

                public String serializedClass(Class type) {
                    if (type == null) {
                        return super.serializedClass(null);
                    }
                    String alias = SaveService.classToAlias(type.getName());
                    return alias == null ? super.serializedClass(type) : alias;
                }
            };
        }
    }
}

