/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.util.FocusRequester;
import org.apache.jmeter.util.JMeterUtils;

public class Close
implements Command {
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doAction(ActionEvent e) {
        Close.performAction(e);
    }

    static boolean performAction(ActionEvent e) {
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "check_dirty"));
        GuiPackage guiPackage = GuiPackage.getInstance();
        if (guiPackage.isDirty()) {
            int response = JOptionPane.showConfirmDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("cancel_new_to_save"), JMeterUtils.getResString("save?"), 1, 3);
            if (response == 0) {
                ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "save"));
            }
            if (response == -1 || response == 2) {
                return false;
            }
        }
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "stop_thread"));
        Close.closeProject(e);
        return true;
    }

    static void closeProject(ActionEvent e) {
        GuiPackage guiPackage = GuiPackage.getInstance();
        guiPackage.clearTestPlan();
        JTree tree = guiPackage.getTreeListener().getJTree();
        tree.setSelectionRow(0);
        FocusRequester.requestFocus(tree);
        ActionRouter.getInstance().actionPerformed(new ActionEvent(e.getSource(), e.getID(), "add_all"));
    }

    static {
        commands.add("close");
    }
}

