/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.RemoteException;
import org.apache.jmeter.samplers.AbstractSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSender;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class DataStrippingSampleSender
extends AbstractSampleSender
implements Serializable {
    private static final long serialVersionUID = -5556040298982085715L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final RemoteSampleListener listener;
    private final SampleSender decoratedSender;

    @Deprecated
    public DataStrippingSampleSender() {
        log.warn("Constructor only intended for use in testing");
        this.listener = null;
        this.decoratedSender = null;
    }

    DataStrippingSampleSender(RemoteSampleListener listener) {
        this.listener = listener;
        this.decoratedSender = null;
        log.info("Using DataStrippingSampleSender for this run");
    }

    DataStrippingSampleSender(SampleSender decorate) {
        this.decoratedSender = decorate;
        this.listener = null;
        log.info("Using DataStrippingSampleSender for this run");
    }

    @Override
    public void testEnded(String host) {
        log.info("Test Ended on " + host);
        if (this.decoratedSender != null) {
            this.decoratedSender.testEnded(host);
        }
    }

    @Override
    public void sampleOccurred(SampleEvent event) {
        SampleResult result = event.getResult();
        if (result.isSuccessful()) {
            this.stripResponse(result);
            for (SampleResult subResult : result.getSubResults()) {
                this.stripResponse(subResult);
            }
        }
        if (this.decoratedSender == null) {
            try {
                this.listener.sampleOccurred(event);
            }
            catch (RemoteException e) {
                log.error("Error sending sample result over network ", (Throwable)e);
            }
        } else {
            this.decoratedSender.sampleOccurred(event);
        }
    }

    private final void stripResponse(SampleResult result) {
        result.setBytes(result.getBytes());
        result.setResponseData(SampleResult.EMPTY_BA);
    }

    private Object readResolve() throws ObjectStreamException {
        log.info("Using DataStrippingSampleSender for this run");
        return this;
    }
}

