/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.jorphan.util.JMeterError;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionRouter
implements ActionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Object LOCK = new Object();
    private static volatile ActionRouter router;
    private Map<String, Set<Command>> commands = new HashMap<String, Set<Command>>();
    private final Map<String, HashSet<ActionListener>> preActionListeners = new HashMap<String, HashSet<ActionListener>>();
    private final Map<String, HashSet<ActionListener>> postActionListeners = new HashMap<String, HashSet<ActionListener>>();

    private ActionRouter() {
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ActionRouter.this.performAction(e);
            }
        });
    }

    private void performAction(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        try {
            try {
                GuiPackage.getInstance().updateCurrentGui();
            }
            catch (Exception err) {
                log.error("performAction(" + actionCommand + ") updateCurrentGui() on" + e.toString() + " caused", (Throwable)err);
                JMeterUtils.reportErrorToUser("Problem updating GUI - see log file for details");
            }
            for (Command c : this.commands.get(actionCommand)) {
                try {
                    this.preActionPerformed(c.getClass(), e);
                    c.doAction(e);
                    this.postActionPerformed(c.getClass(), e);
                }
                catch (IllegalUserActionException err) {
                    JMeterUtils.reportErrorToUser(err.toString());
                }
                catch (Exception err) {
                    log.error("", (Throwable)err);
                }
            }
        }
        catch (NullPointerException er) {
            log.error("performAction(" + actionCommand + ") " + e.toString() + " caused", (Throwable)er);
            JMeterUtils.reportErrorToUser("Sorry, this feature (" + actionCommand + ") not yet implemented");
        }
    }

    public void doActionNow(ActionEvent e) {
        this.performAction(e);
    }

    public Set<Command> getAction(String actionName) {
        HashSet<Command> set = new HashSet<Command>();
        for (Command c : this.commands.get(actionName)) {
            try {
                set.add(c);
            }
            catch (Exception err) {
                log.error("Could not add Command", (Throwable)err);
            }
        }
        return set;
    }

    public Command getAction(String actionName, Class<?> actionClass) {
        for (Command com : this.commands.get(actionName)) {
            if (!com.getClass().equals(actionClass)) continue;
            return com;
        }
        return null;
    }

    public Command getAction(String actionName, String className) {
        for (Command com : this.commands.get(actionName)) {
            if (!com.getClass().getName().equals(className)) continue;
            return com;
        }
        return null;
    }

    public void addPreActionListener(Class<?> action, ActionListener listener) {
        if (action != null) {
            HashSet<ActionListener> set = this.preActionListeners.get(action.getName());
            if (set == null) {
                set = new HashSet();
            }
            set.add(listener);
            this.preActionListeners.put(action.getName(), set);
        }
    }

    public void removePreActionListener(Class<?> action, ActionListener listener) {
        HashSet<ActionListener> set;
        if (action != null && (set = this.preActionListeners.get(action.getName())) != null) {
            set.remove(listener);
            this.preActionListeners.put(action.getName(), set);
        }
    }

    public void addPostActionListener(Class<?> action, ActionListener listener) {
        if (action != null) {
            HashSet<ActionListener> set = this.postActionListeners.get(action.getName());
            if (set == null) {
                set = new HashSet();
            }
            set.add(listener);
            this.postActionListeners.put(action.getName(), set);
        }
    }

    public void removePostActionListener(Class<?> action, ActionListener listener) {
        HashSet<ActionListener> set;
        if (action != null && (set = this.postActionListeners.get(action.getName())) != null) {
            set.remove(listener);
            this.postActionListeners.put(action.getName(), set);
        }
    }

    protected void preActionPerformed(Class<? extends Command> action, ActionEvent e) {
        HashSet<ActionListener> listenerSet;
        if (action != null && (listenerSet = this.preActionListeners.get(action.getName())) != null && listenerSet.size() > 0) {
            ActionListener[] listeners = listenerSet.toArray(new ActionListener[listenerSet.size()]);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].actionPerformed(e);
            }
        }
    }

    protected void postActionPerformed(Class<? extends Command> action, ActionEvent e) {
        HashSet<ActionListener> listenerSet;
        if (action != null && (listenerSet = this.postActionListeners.get(action.getName())) != null && listenerSet.size() > 0) {
            ActionListener[] listeners = listenerSet.toArray(new ActionListener[listenerSet.size()]);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].actionPerformed(e);
            }
        }
    }

    private void populateCommandMap() {
        try {
            List listClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{Class.forName("org.apache.jmeter.gui.action.Command")});
            this.commands = new HashMap<String, Set<Command>>(listClasses.size());
            if (listClasses.size() == 0) {
                log.fatalError("!!!!!Uh-oh, didn't find any action handlers!!!!!");
                throw new JMeterError("No action handlers found - check JMeterHome and libraries");
            }
            for (String strClassName : listClasses) {
                Class<?> commandClass;
                if (!strClassName.startsWith("org.apache.jmeter.gui") || Modifier.isAbstract((commandClass = Class.forName(strClassName)).getModifiers())) continue;
                Command command = (Command)commandClass.newInstance();
                for (String commandName : command.getActionNames()) {
                    Set<Command> commandObjects = this.commands.get(commandName);
                    if (commandObjects == null) {
                        commandObjects = new HashSet<Command>();
                        this.commands.put(commandName, commandObjects);
                    }
                    commandObjects.add(command);
                }
            }
        }
        catch (HeadlessException e) {
            log.warn(e.toString());
        }
        catch (JMeterError e) {
            throw e;
        }
        catch (Exception e) {
            log.error("exception finding action handlers", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionRouter getInstance() {
        if (router == null) {
            Object object = LOCK;
            synchronized (object) {
                if (router == null) {
                    router = new ActionRouter();
                    router.populateCommandMap();
                }
            }
        }
        return router;
    }
}

