/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.jmeter.JMeter;
import org.apache.jmeter.engine.ClientJMeterEngine;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteStart
extends AbstractAction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final String REMOTE_HOSTS = "remote_hosts";
    private static final String REMOTE_HOSTS_SEPARATOR = ",";
    private static final Set<String> commands = new HashSet<String>();
    private final Map<String, JMeterEngine> remoteEngines = new HashMap<String, JMeterEngine>();

    @Override
    public void doAction(ActionEvent e) {
        block5: {
            String action;
            block11: {
                String name;
                block10: {
                    block9: {
                        block8: {
                            String el;
                            block7: {
                                block6: {
                                    block4: {
                                        name = ((Component)e.getSource()).getName();
                                        if (name != null) {
                                            name = name.trim();
                                        }
                                        if (!(action = e.getActionCommand()).equals("remote_stop")) break block4;
                                        this.doRemoteStop(name, true);
                                        break block5;
                                    }
                                    if (!action.equals("remote_shut")) break block6;
                                    this.doRemoteStop(name, false);
                                    break block5;
                                }
                                if (!action.equals("remote_start")) break block7;
                                this.popupShouldSave(e);
                                this.doRemoteInit(name);
                                this.doRemoteStart(name);
                                break block5;
                            }
                            if (!action.equals("remote_start_all")) break block8;
                            this.popupShouldSave(e);
                            String remote_hosts_string = JMeterUtils.getPropDefault(REMOTE_HOSTS, LOCAL_HOST);
                            StringTokenizer st = new StringTokenizer(remote_hosts_string, REMOTE_HOSTS_SEPARATOR);
                            while (st.hasMoreElements()) {
                                el = (String)st.nextElement();
                                this.doRemoteInit(el.trim());
                            }
                            st = new StringTokenizer(remote_hosts_string, REMOTE_HOSTS_SEPARATOR);
                            while (st.hasMoreElements()) {
                                el = (String)st.nextElement();
                                this.doRemoteStart(el.trim());
                            }
                            break block5;
                        }
                        if (!action.equals("remote_stop_all")) break block9;
                        this.doRemoteStopAll(true);
                        break block5;
                    }
                    if (!action.equals("remote_shut_all")) break block10;
                    this.doRemoteStopAll(false);
                    break block5;
                }
                if (!action.equals("remote_exit")) break block11;
                this.doRemoteExit(name);
                break block5;
            }
            if (!action.equals("remote_exit_all")) break block5;
            String remote_hosts_string = JMeterUtils.getPropDefault(REMOTE_HOSTS, LOCAL_HOST);
            StringTokenizer st = new StringTokenizer(remote_hosts_string, REMOTE_HOSTS_SEPARATOR);
            while (st.hasMoreElements()) {
                String el = (String)st.nextElement();
                this.doRemoteExit(el.trim());
            }
        }
    }

    private void doRemoteStopAll(boolean now) {
        String remote_hosts_string = JMeterUtils.getPropDefault(REMOTE_HOSTS, LOCAL_HOST);
        StringTokenizer st = new StringTokenizer(remote_hosts_string, REMOTE_HOSTS_SEPARATOR);
        while (st.hasMoreElements()) {
            String el = (String)st.nextElement();
            this.doRemoteStop(el.trim(), now);
        }
    }

    private void doRemoteStop(String name, boolean now) {
        GuiPackage.getInstance().getMainFrame().showStoppingMessage(name);
        JMeterEngine engine = this.remoteEngines.get(name);
        engine.stopTest(now);
    }

    private void doRemoteExit(String name) {
        JMeterEngine engine = this.remoteEngines.get(name);
        if (engine == null) {
            return;
        }
        engine.exit();
    }

    private void doRemoteStart(String name) {
        JMeterEngine engine = this.remoteEngines.get(name);
        if (engine != null) {
            try {
                engine.runTest();
            }
            catch (IllegalStateException e) {
                JMeterUtils.reportErrorToUser(e.getMessage(), JMeterUtils.getResString("remote_error_starting"));
            }
            catch (JMeterEngineException e) {
                JMeterUtils.reportErrorToUser(e.getMessage(), JMeterUtils.getResString("remote_error_starting"));
            }
        }
    }

    private void doRemoteInit(String name) {
        JMeterEngine engine = this.remoteEngines.get(name);
        if (engine == null) {
            try {
                log.info("Initialising remote engine: " + name);
                engine = new ClientJMeterEngine(name);
                this.remoteEngines.put(name, engine);
            }
            catch (Exception ex) {
                log.error("Failed to initialise remote engine", (Throwable)ex);
                JMeterUtils.reportErrorToUser(ex.getMessage(), JMeterUtils.getResString("remote_error_init") + ": " + name);
                return;
            }
        } else {
            engine.reset();
        }
        this.initEngine(engine, name);
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    private void initEngine(JMeterEngine engine, String host) {
        GuiPackage gui = GuiPackage.getInstance();
        HashTree testTree = gui.getTreeModel().getTestPlan();
        JMeter.convertSubTree(testTree);
        testTree.add(testTree.getArray()[0], (Object)gui.getMainFrame());
        engine.configure(testTree);
    }

    static {
        commands.add("remote_start");
        commands.add("remote_stop");
        commands.add("remote_shut");
        commands.add("remote_start_all");
        commands.add("remote_stop_all");
        commands.add("remote_shut_all");
        commands.add("remote_exit");
        commands.add("remote_exit_all");
    }
}

