/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.util.JMeterUtils;

public class FilePanel
extends HorizontalPanel
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private final JTextField filename = new JTextField(20);
    private final JLabel label = new JLabel(JMeterUtils.getResString("file_visualizer_filename"));
    private final JButton browse = new JButton(JMeterUtils.getResString("browse"));
    private static final String ACTION_BROWSE = "browse";
    private final List<ChangeListener> listeners = new LinkedList<ChangeListener>();
    private final String title;
    private final String[] filetypes;

    public FilePanel() {
        this("", (String)null);
    }

    public FilePanel(String title) {
        this(title, (String)null);
    }

    public FilePanel(String title, String filetype) {
        this.title = title;
        this.filetypes = filetype == null ? null : new String[]{filetype};
        this.init();
    }

    public FilePanel(ChangeListener l, String title) {
        this(title, (String)null);
        this.listeners.add(l);
    }

    public FilePanel(String resString, String[] exts) {
        this.title = resString;
        this.filetypes = new String[exts.length];
        System.arraycopy(exts, 0, this.filetypes, 0, exts.length);
        this.init();
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    private void init() {
        this.setBorder(BorderFactory.createTitledBorder(this.title));
        this.add(this.label);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.filename);
        this.add(Box.createHorizontalStrut(5));
        this.filename.addActionListener(this);
        this.add(this.browse);
        this.browse.setActionCommand(ACTION_BROWSE);
        this.browse.addActionListener(this);
    }

    public void clearGui() {
        this.filename.setText("");
    }

    public void enableFile(boolean enable) {
        this.browse.setEnabled(enable);
        this.filename.setEnabled(enable);
    }

    public String getFilename() {
        return this.filename.getText();
    }

    public void setFilename(String f) {
        this.filename.setText(f);
    }

    private void fireFileChanged() {
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(new ChangeEvent(this));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(ACTION_BROWSE)) {
            JFileChooser chooser = this.filetypes == null || this.filetypes.length == 0 ? FileDialoger.promptToOpenFile() : FileDialoger.promptToOpenFile(this.filetypes);
            if (chooser != null && chooser.getSelectedFile() != null) {
                this.filename.setText(chooser.getSelectedFile().getPath());
                this.fireFileChanged();
            }
        } else {
            this.fireFileChanged();
        }
    }
}

