/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.AbstractProperty;

public class BooleanProperty
extends AbstractProperty {
    private static final long serialVersionUID = 233L;
    private boolean value;
    private transient boolean savedValue;

    public BooleanProperty(String name, boolean v) {
        super(name);
        this.value = v;
    }

    public BooleanProperty() {
    }

    public void setObjectValue(Object v) {
        this.value = v instanceof Boolean ? ((Boolean)v).booleanValue() : Boolean.valueOf(v.toString()).booleanValue();
    }

    public String getStringValue() {
        return Boolean.toString(this.value);
    }

    public Object getObjectValue() {
        return this.value;
    }

    public BooleanProperty clone() {
        BooleanProperty prop = (BooleanProperty)super.clone();
        prop.value = this.value;
        return prop;
    }

    public boolean getBooleanValue() {
        return this.value;
    }

    public void setRunningVersion(boolean runningVersion) {
        this.savedValue = this.value;
        super.setRunningVersion(runningVersion);
    }

    public void recoverRunningVersion(TestElement owner) {
        this.value = this.savedValue;
    }
}

