/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.util.JMeterUtils;

public final class JMeterContextService {
    private static final ThreadLocal<JMeterContext> threadContext = new ThreadLocal<JMeterContext>(){

        @Override
        public JMeterContext initialValue() {
            return new JMeterContext();
        }
    };
    private static long testStart = 0L;
    private static int numberOfActiveThreads = 0;
    private static int totalThreads = 0;

    private JMeterContextService() {
    }

    public static JMeterContext getContext() {
        return threadContext.get();
    }

    static void removeContext() {
        threadContext.remove();
    }

    public static void replaceContext(JMeterContext context) {
        threadContext.remove();
        threadContext.set(context);
    }

    public static synchronized void startTest() {
        if (testStart == 0L) {
            numberOfActiveThreads = 0;
            testStart = System.currentTimeMillis();
            JMeterUtils.setProperty("TESTSTART.MS", Long.toString(testStart));
        }
    }

    static synchronized void incrNumberOfThreads() {
        ++numberOfActiveThreads;
    }

    static synchronized void decrNumberOfThreads() {
        --numberOfActiveThreads;
    }

    public static synchronized int getNumberOfThreads() {
        return numberOfActiveThreads;
    }

    public static synchronized void endTest() {
        testStart = 0L;
    }

    public static synchronized long getTestStartTime() {
        return testStart;
    }

    public static synchronized int getTotalThreads() {
        return totalThreads;
    }

    public static synchronized void addTotalThreads(int thisGroup) {
        totalThreads += thisGroup;
    }

    public static synchronized void clearTotalThreads() {
        totalThreads = 0;
    }
}

