/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.Serializable;
import java.util.List;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterException;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanShellTestElement
extends AbstractTestElement
implements Serializable,
Cloneable,
ThreadListener,
TestListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 4L;
    private String parameters;
    private String filename;
    private String script;
    private boolean resetInterpreter = false;
    private transient BeanShellInterpreter bshInterpreter = null;
    private transient boolean hasInitFile = false;

    public BeanShellTestElement() {
        this.init();
    }

    protected abstract String getInitFileProperty();

    protected BeanShellInterpreter getBeanShellInterpreter() {
        if (this.isResetInterpreter()) {
            try {
                this.bshInterpreter.reset();
            }
            catch (ClassNotFoundException e) {
                log.error("Cannot reset BeanShell: " + e.toString());
            }
        }
        JMeterContext jmctx = JMeterContextService.getContext();
        JMeterVariables vars = jmctx.getVariables();
        try {
            this.bshInterpreter.set("ctx", jmctx);
            this.bshInterpreter.set("Label", this.getName());
            this.bshInterpreter.set("prev", jmctx.getPreviousResult());
            this.bshInterpreter.set("props", JMeterUtils.getJMeterProperties());
            this.bshInterpreter.set("vars", vars);
        }
        catch (JMeterException e) {
            log.warn("Problem setting one or more BeanShell variables " + (Object)((Object)e));
        }
        return this.bshInterpreter;
    }

    private void init() {
        this.parameters = "";
        this.filename = "";
        this.script = "";
        try {
            String initFileName = JMeterUtils.getProperty(this.getInitFileProperty());
            this.hasInitFile = initFileName != null;
            this.bshInterpreter = new BeanShellInterpreter(initFileName, log);
        }
        catch (ClassNotFoundException e) {
            log.error("Cannot find BeanShell: " + e.toString());
        }
    }

    protected Object readResolve() {
        this.init();
        return this;
    }

    @Override
    public Object clone() {
        BeanShellTestElement o = (BeanShellTestElement)super.clone();
        o.init();
        return o;
    }

    protected Object processFileOrScript(BeanShellInterpreter bsh) throws JMeterException {
        String fileName = this.getFilename();
        String params = this.getParameters();
        bsh.set("FileName", fileName);
        bsh.set("Parameters", params);
        bsh.set("bsh.args", JOrphanUtils.split((String)params, (String)" "));
        if (fileName.length() == 0) {
            return bsh.eval(this.getScript());
        }
        return bsh.source(fileName);
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String s) {
        this.script = s;
    }

    @Override
    public void threadStarted() {
        if (this.bshInterpreter == null || !this.hasInitFile) {
            return;
        }
        try {
            this.bshInterpreter.evalNoLog("threadStarted()");
        }
        catch (JMeterException ignored) {
            log.debug(this.getClass().getName() + " : " + ignored.getLocalizedMessage());
        }
    }

    @Override
    public void threadFinished() {
        if (this.bshInterpreter == null || !this.hasInitFile) {
            return;
        }
        try {
            this.bshInterpreter.evalNoLog("threadFinished()");
        }
        catch (JMeterException ignored) {
            log.debug(this.getClass().getName() + " : " + ignored.getLocalizedMessage());
        }
    }

    @Override
    public void testEnded() {
        if (this.bshInterpreter == null || !this.hasInitFile) {
            return;
        }
        try {
            this.bshInterpreter.evalNoLog("testEnded()");
        }
        catch (JMeterException ignored) {
            log.debug(this.getClass().getName() + " : " + ignored.getLocalizedMessage());
        }
    }

    @Override
    public void testEnded(String host) {
        if (this.bshInterpreter == null || !this.hasInitFile) {
            return;
        }
        try {
            this.bshInterpreter.eval("testEnded(" + host + ")");
        }
        catch (JMeterException ignored) {
            log.debug(this.getClass().getName() + " : " + ignored.getLocalizedMessage());
        }
    }

    @Override
    public void testIterationStart(LoopIterationEvent event) {
    }

    @Override
    public void testStarted() {
        if (this.bshInterpreter == null || !this.hasInitFile) {
            return;
        }
        try {
            this.bshInterpreter.evalNoLog("testStarted()");
        }
        catch (JMeterException ignored) {
            log.debug(this.getClass().getName() + " : " + ignored.getLocalizedMessage());
        }
    }

    @Override
    public void testStarted(String host) {
        if (this.bshInterpreter == null || !this.hasInitFile) {
            return;
        }
        try {
            this.bshInterpreter.eval("testStarted(" + host + ")");
        }
        catch (JMeterException ignored) {
            log.debug(this.getClass().getName() + " : " + ignored.getLocalizedMessage());
        }
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String s) {
        this.parameters = s;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String s) {
        this.filename = s;
    }

    public boolean isResetInterpreter() {
        return this.resetInterpreter;
    }

    public void setResetInterpreter(boolean b) {
        this.resetInterpreter = b;
    }

    @Override
    public List<String> getSearchableTokens() throws Exception {
        List<String> result = super.getSearchableTokens();
        result.add(this.getScript());
        return result;
    }
}

